/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.chains.plugins.PrePostTaskActions;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.PrePostTaskActionsDescriptor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.InternalTaskType;
import com.atlassian.bamboo.task.TaskActionExecutor;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TaskActionExecutorImpl
implements TaskActionExecutor {
    private static final Logger log = Logger.getLogger(TaskActionExecutorImpl.class);
    private final PluginAccessor pluginAccessor;

    public TaskActionExecutorImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    protected <D extends PrePostTaskActionsDescriptor, T extends InternalTaskType> Collection<PrePostTaskActions> getTaskActionsFor(Class<D> descriptorClass, T task) {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(descriptorClass), new IsActionForTask(task)), new GetModuleFromDescriptor()));
    }

    @Override
    public Collection<PrePostTaskActions> executePreTaskActions(final @NotNull InternalTaskType task, final @NotNull CommonTaskContext taskContext) {
        Collection<PrePostTaskActions> actions = this.getTaskActionsFor(PrePostTaskActionsDescriptor.class, task);
        for (final PrePostTaskActions action : actions) {
            String errorMessage = String.format("Failed to run '%s' pre-task action for '%s' task.", action.getClass().getSimpleName(), task.toString());
            BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Callable<Object>(errorMessage){

                @Override
                @Nullable
                public Object call() throws Exception {
                    action.executeBefore(task, taskContext);
                    return null;
                }
            });
        }
        return actions;
    }

    @Override
    public TaskResult executePostTaskActions(final @NotNull InternalTaskType task, @Nullable TaskResult taskResult, @NotNull Collection<PrePostTaskActions> taskActions) {
        for (final PrePostTaskActions action : taskActions) {
            String errorMessage = String.format("Failed to run '%s' post-task action for '%s' task.", action.getClass().getSimpleName(), task.toString());
            final TaskResult taskResultIn = taskResult;
            taskResult = BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Callable<TaskResult>(errorMessage){

                @Override
                @Nullable
                public TaskResult call() throws Exception {
                    return action.executeAfter(task, taskResultIn);
                }
            });
        }
        return taskResult;
    }

    static class IsActionForTask<D extends PrePostTaskActionsDescriptor, T extends InternalTaskType>
    implements Predicate<D> {
        private T currentTaskType;

        public IsActionForTask(T taskType) {
            this.currentTaskType = taskType;
        }

        public boolean apply(@Nullable D moduleDescriptor) {
            Class<?> expectedTaskClass = null;
            try {
                expectedTaskClass = moduleDescriptor != null && ((PrePostTaskActionsDescriptor)((Object)moduleDescriptor)).getTaskClass() != null ? Class.forName(((PrePostTaskActionsDescriptor)((Object)moduleDescriptor)).getTaskClass()) : null;
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("A task class " + ((PrePostTaskActionsDescriptor)((Object)moduleDescriptor)).getTaskClass() + " declared in a module descriptor " + ((PrePostTaskActionsDescriptor)((Object)moduleDescriptor)).toString() + " was not found. Pre/post task actions will not be executed."));
            }
            return this.currentTaskType != null && expectedTaskClass != null && Narrow.to(this.currentTaskType, expectedTaskClass) != null;
        }
    }

    static class GetModuleFromDescriptor<T>
    implements Function<AbstractBambooModuleDescriptor<T>, T> {
        GetModuleFromDescriptor() {
        }

        public T apply(@Nullable AbstractBambooModuleDescriptor<T> moduleDescriptor) {
            return moduleDescriptor != null ? (T)moduleDescriptor.getModule() : null;
        }
    }
}

