/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.persister.TaskAuditLogHelper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskPredicates;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.atlassian.bamboo.task.repository.RepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TaskConfigurationServiceImpl
implements TaskConfigurationService {
    private static final Logger log = Logger.getLogger(TaskConfigurationServiceImpl.class);
    private static final String TASK_HAS_BEEN_REMOVED = "Task has been removed.";
    private static final String TASK_HAS_BEEN_CREATED = "Task has been created.";
    private static final String TASK_HAS_BEEN_MOVED = "Task has been moved.";
    private final BuildDefinitionManager buildDefinitionManager;
    private final TaskManager taskManager;
    private final TextProvider textProvider;
    private final PlanManager planManager;
    private final AuditLogService auditLogService;
    private final ScopedExclusionService scopedExclusionService;

    public TaskConfigurationServiceImpl(BuildDefinitionManager buildDefinitionManager, TaskManager taskManager, TextProvider textProvider, PlanManager planManager, AuditLogService auditLogService, ScopedExclusionService scopedExclusionService) {
        this.buildDefinitionManager = buildDefinitionManager;
        this.taskManager = taskManager;
        this.textProvider = textProvider;
        this.planManager = planManager;
        this.auditLogService = auditLogService;
        this.scopedExclusionService = scopedExclusionService;
    }

    public TaskDefinition createTask(@NotNull PlanKey planKey, @NotNull TaskModuleDescriptor taskDescriptor, @Nullable String userDescription, boolean isEnabled, @NotNull Map<String, String> configuration, @NotNull TaskRootDirectorySelector taskRootDirectorySelector) {
        return this.createTask(planKey, taskDescriptor, userDescription, isEnabled, Collections.emptyList(), configuration, taskRootDirectorySelector);
    }

    public TaskDefinition createTask(@NotNull PlanKey planKey, @NotNull TaskModuleDescriptor taskDescriptor, @Nullable String userDescription, boolean isEnabled, @NotNull List<TaskConditionConfig> conditions, @NotNull Map<String, String> configuration, @NotNull TaskRootDirectorySelector taskRootDirectorySelector) {
        Supplier<TaskDefinition> createTaskFunctor = this.createTaskFunctor(planKey, taskDescriptor, userDescription, isEnabled, conditions, configuration, taskRootDirectorySelector);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(createTaskFunctor);
        return ScopedExclusionServiceHelper.withLockedJob(this.scopedExclusionService, planKey, ScopedExclusionServiceHelper.clearSession(functor));
    }

    private Supplier<TaskDefinition> createTaskFunctor(final PlanKey planKey, final TaskModuleDescriptor taskDescriptor, final String userDescription, final boolean isEnabled, final @NotNull List<TaskConditionConfig> conditions, final Map<String, String> configuration, final TaskRootDirectorySelector taskRootDirectorySelector) {
        return new Supplier<TaskDefinition>(){

            @Override
            public TaskDefinition get() {
                Job job = (Job)TaskConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Job.class);
                if (job == null) {
                    throw new IllegalArgumentException("Could not create a new Task, no Job was found with the key: " + planKey);
                }
                BuildDefinition newBuildDefinition = TaskConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(job.getPlanKey());
                List tasks = newBuildDefinition.getTaskDefinitions();
                TaskDefinitionImpl taskDefinition = new TaskDefinitionImpl(TaskConfigurationUtils.getUniqueId(tasks), taskDescriptor.getCompleteKey(), userDescription, isEnabled, conditions, configuration, false, taskRootDirectorySelector);
                List<TaskDefinition> newTasks = TaskConfigurationUtils.addTaskToList(tasks, taskDefinition);
                newBuildDefinition.setTaskDefinitions(newTasks);
                TaskConfigurationServiceImpl.this.taskManager.calculateRequirementsForTaskDefinition(job, (TaskDefinition)taskDefinition);
                TaskConfigurationServiceImpl.this.taskManager.updateWorkingDirSelectors((ImmutableBuildable)job, newBuildDefinition, Collections.emptyMap());
                TaskConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)job, newBuildDefinition);
                TaskConfigurationServiceImpl.this.auditLogService.log(TaskConfigurationServiceImpl.TASK_HAS_BEEN_CREATED, (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.TASK, TaskAuditLogHelper.getTaskHeader(TaskConfigurationServiceImpl.this.taskManager, taskDefinition)));
                return taskDefinition;
            }
        };
    }

    public void createTaskList(PlanKey planKey, @NotNull List<TaskDefinition> taskDefinitions) {
        Supplier<TaskDefinition> createTaskListFunctor = this.createTaskListFunctor(planKey, taskDefinitions);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(createTaskListFunctor);
        ScopedExclusionServiceHelper.withLockedJob(this.scopedExclusionService, planKey, functor);
    }

    private Supplier<TaskDefinition> createTaskListFunctor(final PlanKey planKey, final List<TaskDefinition> taskDefinitions) {
        return new Supplier<TaskDefinition>(){

            @Override
            public TaskDefinition get() {
                Job job = (Job)TaskConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Job.class);
                if (job == null) {
                    throw new IllegalArgumentException("Could not create a new Task, no Job was found with the key: " + planKey);
                }
                BuildDefinition newBuildDefinition = TaskConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(job.getPlanKey());
                List removedTasks = newBuildDefinition.getTaskDefinitions();
                for (TaskDefinition removedTask : removedTasks) {
                    TaskConfigurationServiceImpl.this.taskManager.removeRequirementsForTaskDefinition((Buildable)job, removedTask);
                }
                newBuildDefinition.setTaskDefinitions(taskDefinitions);
                for (TaskDefinition taskDefinition : taskDefinitions) {
                    TaskConfigurationServiceImpl.this.taskManager.calculateRequirementsForTaskDefinition(job, taskDefinition);
                }
                TaskConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)job, newBuildDefinition);
                for (TaskDefinition taskDefinition : taskDefinitions) {
                    TaskConfigurationServiceImpl.this.auditLogService.log(TaskConfigurationServiceImpl.TASK_HAS_BEEN_CREATED, (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.TASK, TaskAuditLogHelper.getTaskHeader(TaskConfigurationServiceImpl.this.taskManager, taskDefinition)));
                }
                for (TaskDefinition removedTask : removedTasks) {
                    TaskConfigurationServiceImpl.this.auditLogService.log(TaskConfigurationServiceImpl.TASK_HAS_BEEN_REMOVED, (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.TASK, TaskAuditLogHelper.getTaskHeader(TaskConfigurationServiceImpl.this.taskManager, removedTask)));
                }
                return null;
            }
        };
    }

    public void moveTask(@NotNull PlanKey planKey, long taskId, long beforeId, long afterId, boolean isFinal) {
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(this.moveTaskFunctor(planKey, taskId, beforeId, afterId, isFinal));
        ScopedExclusionServiceHelper.withLockedJob(this.scopedExclusionService, planKey, functor);
    }

    private Runnable moveTaskFunctor(final PlanKey planKey, final long taskId, final long beforeId, final long afterId, final boolean isFinal) {
        return new Runnable(){

            @Override
            public void run() {
                Buildable buildable = (Buildable)TaskConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Buildable.class);
                if (buildable == null) {
                    throw new IllegalArgumentException("Could not create a new Task, no Job was found with the key: " + planKey);
                }
                BuildDefinition newBuildDefinition = TaskConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(buildable.getPlanKey());
                List tasks = newBuildDefinition.getTaskDefinitions();
                TaskDefinition toMove = TaskConfigurationServiceImpl.this.getTaskById(tasks, taskId);
                if (toMove == null) {
                    throw new IllegalStateException("Task with ID '" + taskId + "' is no longer in the list.");
                }
                boolean oldIsFinalising = toMove.isFinalising();
                List<TaskDefinition> newTasks = TaskConfigurationUtils.getNewTaskList(tasks, toMove, beforeId, afterId, isFinal);
                newBuildDefinition.setTaskDefinitions(newTasks);
                TaskConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)buildable, newBuildDefinition);
                TaskConfigurationServiceImpl.this.auditLogService.log(TaskConfigurationServiceImpl.TASK_HAS_BEEN_MOVED, (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.TASK, TaskAuditLogHelper.getTaskHeader(TaskConfigurationServiceImpl.this.taskManager, toMove)));
                TaskConfigurationServiceImpl.this.logTaskFinalisingFlagChange(planKey, toMove, oldIsFinalising);
            }
        };
    }

    public void deleteTask(@NotNull PlanKey planKey, long taskId) {
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(this.deleteTaskFunctor(planKey, taskId));
        ScopedExclusionServiceHelper.withLockedJob(this.scopedExclusionService, planKey, functor);
    }

    private Runnable deleteTaskFunctor(final PlanKey planKey, final long taskId) {
        return new Runnable(){

            @Override
            public void run() {
                Buildable buildable = (Buildable)TaskConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Buildable.class);
                if (buildable == null) {
                    throw new IllegalArgumentException("Could not create a new Task, no Job was found with the key: " + planKey);
                }
                BuildDefinition newBuildDefinition = TaskConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(buildable.getPlanKey());
                List tasks = newBuildDefinition.getTaskDefinitions();
                TaskDefinition removedTask = (TaskDefinition)Iterables.find((Iterable)tasks, TaskPredicates.hasTaskDefinitionEqualId(taskId), null);
                if (removedTask == null) {
                    throw new IllegalStateException(TaskConfigurationServiceImpl.this.textProvider.getText("tasks.delete.error", (List)Lists.newArrayList((Object[])new Long[]{taskId})));
                }
                tasks.remove(removedTask);
                TaskConfigurationServiceImpl.this.taskManager.removeRequirementsForTaskDefinition(buildable, removedTask);
                TaskConfigurationServiceImpl.this.taskManager.updateWorkingDirSelectors((ImmutableBuildable)buildable, newBuildDefinition, Collections.emptyMap());
                TaskConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)buildable, newBuildDefinition);
                TaskConfigurationServiceImpl.this.auditLogService.log(TaskConfigurationServiceImpl.TASK_HAS_BEEN_REMOVED, (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.TASK, TaskAuditLogHelper.getTaskHeader(TaskConfigurationServiceImpl.this.taskManager, removedTask)));
            }
        };
    }

    public TaskDefinition editTask(@NotNull PlanKey planKey, long taskId, @Nullable String userDescription, boolean isEnabled, @NotNull Map<String, String> taskConfigurationMap, @NotNull TaskRootDirectorySelector taskRootDirectorySelector) throws IllegalArgumentException {
        return this.editTask(planKey, taskId, userDescription, isEnabled, Collections.emptyList(), taskConfigurationMap, taskRootDirectorySelector);
    }

    public TaskDefinition editTask(@NotNull PlanKey planKey, long taskId, @Nullable String userDescription, boolean isEnabled, @NotNull List<TaskConditionConfig> conditions, @NotNull Map<String, String> taskConfigurationMap, @NotNull TaskRootDirectorySelector taskRootDirectorySelector) throws IllegalArgumentException {
        Supplier<TaskDefinition> editTaskFunctor = this.editTaskFunctor(planKey, taskId, userDescription, isEnabled, conditions, taskConfigurationMap, taskRootDirectorySelector);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(editTaskFunctor);
        return ScopedExclusionServiceHelper.withLockedJob(this.scopedExclusionService, planKey, functor);
    }

    private Supplier<TaskDefinition> editTaskFunctor(final PlanKey planKey, final long taskId, final String userDescription, final boolean isEnabled, final List<TaskConditionConfig> conditions, final Map<String, String> taskConfigurationMap, final TaskRootDirectorySelector taskRootDirectorySelector) {
        return new Supplier<TaskDefinition>(){

            @Override
            public TaskDefinition get() {
                Job job = (Job)TaskConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Job.class);
                if (job == null) {
                    throw new IllegalArgumentException("Could not create a new Task, no Job was found with the key: " + planKey);
                }
                BuildDefinition newBuildDefinition = TaskConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(job.getPlanKey());
                List tasks = newBuildDefinition.getTaskDefinitions();
                TaskDefinition taskDefinition = TaskConfigurationServiceImpl.this.getTaskById(tasks, taskId);
                if (taskDefinition == null) {
                    throw new IllegalArgumentException(TaskConfigurationServiceImpl.this.textProvider.getText("tasks.edit.error.incorrectId", (List)Lists.newArrayList((Object[])new Long[]{taskId})));
                }
                Map oldConfiguration = taskDefinition.getConfiguration();
                String oldDescription = taskDefinition.getUserDescription();
                boolean oldIsEnabled = taskDefinition.isEnabled();
                taskDefinition.setUserDescription(userDescription);
                taskDefinition.setEnabled(isEnabled);
                taskDefinition.setConditions(conditions);
                taskDefinition.setConfiguration(taskConfigurationMap);
                taskDefinition.setRootDirectorySelector(taskRootDirectorySelector);
                TaskConfigurationServiceImpl.this.taskManager.calculateRequirementsForTaskDefinition(job, taskDefinition);
                TaskConfigurationServiceImpl.this.taskManager.updateWorkingDirSelectors((ImmutableBuildable)job, newBuildDefinition, Collections.emptyMap());
                TaskConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)job, newBuildDefinition);
                TaskAuditLogHelper.logTaskConfigurationChanges(TaskConfigurationServiceImpl.this.auditLogService, TaskConfigurationServiceImpl.this.taskManager, AuditLogEntityType.PLAN, (Key)planKey, taskDefinition, oldConfiguration, oldDescription, oldIsEnabled);
                return taskDefinition;
            }
        };
    }

    public TaskDefinition setTaskState(@NotNull PlanKey planKey, long taskId, boolean disabled) throws IllegalArgumentException {
        Supplier<TaskDefinition> setTaskStateFunctor = this.setTaskStateFunctor(planKey, taskId, disabled);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(setTaskStateFunctor);
        return ScopedExclusionServiceHelper.withLockedJob(this.scopedExclusionService, planKey, functor);
    }

    private Supplier<TaskDefinition> setTaskStateFunctor(final PlanKey planKey, final long taskId, final boolean isEnabled) {
        return new Supplier<TaskDefinition>(){

            @Override
            public TaskDefinition get() {
                Job job = (Job)TaskConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Job.class);
                if (job == null) {
                    throw new IllegalArgumentException("Could not set a new state for Task, no Job was found with the key: " + planKey);
                }
                BuildDefinition newBuildDefinition = TaskConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(job.getPlanKey());
                List tasks = newBuildDefinition.getTaskDefinitions();
                TaskDefinition taskDefinition = TaskConfigurationServiceImpl.this.getTaskById(tasks, taskId);
                if (taskDefinition == null) {
                    throw new IllegalArgumentException(TaskConfigurationServiceImpl.this.textProvider.getText("tasks.edit.error.incorrectId", (List)Lists.newArrayList((Object[])new Long[]{taskId})));
                }
                boolean oldIsEnabled = taskDefinition.isEnabled();
                taskDefinition.setEnabled(isEnabled);
                TaskConfigurationServiceImpl.this.taskManager.calculateRequirementsForTaskDefinition(job, taskDefinition);
                TaskConfigurationServiceImpl.this.taskManager.updateWorkingDirSelectors((ImmutableBuildable)job, newBuildDefinition, Collections.emptyMap());
                TaskConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)job, newBuildDefinition);
                TaskAuditLogHelper.logTaskConfigurationChanges(TaskConfigurationServiceImpl.this.auditLogService, TaskConfigurationServiceImpl.this.taskManager, AuditLogEntityType.PLAN, (Key)planKey, taskDefinition, taskDefinition.getConfiguration(), taskDefinition.getUserDescription(), oldIsEnabled);
                return taskDefinition;
            }
        };
    }

    public List<TaskDefinition> getRelevantTasksForRepositoryId(@NotNull ImmutableJob job, long repositoryId) {
        Predicate<TaskDefinition> taskUsesRepository = taskDefinition -> {
            RepositoryAwareTaskConfigurator taskConfigurator;
            TaskModuleDescriptor taskModuleDescriptor = this.taskManager.getTaskDescriptor(taskDefinition.getPluginKey());
            if (taskModuleDescriptor != null && (taskConfigurator = (RepositoryAwareTaskConfigurator)Narrow.to((Object)taskModuleDescriptor.getTaskConfigurator(), RepositoryAwareTaskConfigurator.class)) != null) {
                return taskConfigurator.getRepositoriesUsedByTask(taskDefinition, job).stream().anyMatch(definition -> definition.getId() == repositoryId);
            }
            return false;
        };
        return job.getBuildDefinition().getTaskDefinitions().stream().filter(taskUsesRepository).collect(Collectors.toList());
    }

    public void updateRepositoryIdsInJobsTasks(@NotNull Job job, Map<Long, Long> repositoryIdsChanges) {
        ScopedExclusionService.ExclusiveFunction adapt = ScopedExclusionServiceHelper.adapt(this.updateRepositoryIdsFunctor(job, repositoryIdsChanges));
        ScopedExclusionServiceHelper.withLockedJob(this.scopedExclusionService, job.getPlanKey(), adapt);
    }

    private Runnable updateRepositoryIdsFunctor(final Job job, final Map<Long, Long> repositoryIdsChanges) {
        return new Runnable(){

            @Override
            public void run() {
                if (job.getBuildDefinitionXml() != null) {
                    BuildDefinition newBuildDefinition = TaskConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(job.getPlanKey());
                    List tasks = newBuildDefinition.getTaskDefinitions();
                    for (TaskDefinition taskDefinition : tasks) {
                        HashMap<String, String> oldConfiguration = new HashMap<String, String>(taskDefinition.getConfiguration());
                        TaskConfigurationServiceImpl.this.taskManager.updateRepositoryIdsInTask(taskDefinition, repositoryIdsChanges);
                        TaskConfigurationServiceImpl.this.taskManager.calculateRequirementsForTaskDefinition(job, taskDefinition);
                        TaskAuditLogHelper.logTaskConfigurationChanges(TaskConfigurationServiceImpl.this.auditLogService, TaskConfigurationServiceImpl.this.taskManager, AuditLogEntityType.PLAN, (Key)job.getPlanKey(), taskDefinition, oldConfiguration, taskDefinition.getUserDescription(), taskDefinition.isEnabled());
                    }
                    TaskConfigurationServiceImpl.this.taskManager.updateWorkingDirSelectors((ImmutableBuildable)job, newBuildDefinition, repositoryIdsChanges);
                    TaskConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)job, newBuildDefinition);
                }
            }
        };
    }

    @NotNull
    public Collection<Requirement> getTasksRequirements(@NotNull PlanKey planKey) {
        Job job = (Job)this.planManager.getPlanByKeyIfOfType(planKey, Job.class);
        if (job == null) {
            throw new IllegalArgumentException("Could not check a Task requirements, no Job was found with the key: " + planKey);
        }
        return this.taskManager.getTasksRequirements(job);
    }

    public void moveFinalBar(PlanKey planKey, long beforeId, long afterId) throws IllegalArgumentException, IllegalStateException {
        ScopedExclusionService.ExclusiveFunction adapt = ScopedExclusionServiceHelper.adapt(this.moveFinalBarFunctor(planKey, beforeId, afterId));
        ScopedExclusionServiceHelper.withLockedJob(this.scopedExclusionService, planKey, adapt);
    }

    private Runnable moveFinalBarFunctor(final PlanKey planKey, final long beforeId, final long afterId) {
        return new Runnable(){

            @Override
            public void run() {
                Buildable buildable = (Buildable)TaskConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Buildable.class);
                if (buildable == null) {
                    throw new IllegalArgumentException("Could not create a new Task, no Job was found with the key: " + planKey);
                }
                BuildDefinition newBuildDefinition = TaskConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(buildable.getPlanKey());
                List tasks = newBuildDefinition.getTaskDefinitions();
                Collection oldFinaliseFlags = tasks.stream().map(TaskIdentifier::isFinalising).collect(Collectors.toList());
                TaskConfigurationUtils.adjustFinalisingBar(tasks, beforeId, afterId);
                TaskConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)buildable, newBuildDefinition);
                Iterator oldValueIter = oldFinaliseFlags.iterator();
                for (TaskDefinition taskDefinition : tasks) {
                    Boolean oldValue = (Boolean)oldValueIter.next();
                    TaskConfigurationServiceImpl.this.logTaskFinalisingFlagChange(planKey, taskDefinition, oldValue);
                }
            }
        };
    }

    @Nullable
    protected TaskDefinition getTaskById(@NotNull List<TaskDefinition> tasks, long id) {
        return (TaskDefinition)Iterables.find(tasks, TaskPredicates.hasTaskDefinitionEqualId(id), null);
    }

    private void logTaskFinalisingFlagChange(PlanKey planKey, TaskDefinition taskDefinition, boolean oldValue) {
        this.auditLogService.log("finalising", Boolean.toString(oldValue), Boolean.toString(taskDefinition.isFinalising()), (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.TASK, TaskAuditLogHelper.getTaskHeader(this.taskManager, taskDefinition)));
    }
}

