/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.task.TaskContextHelperService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskPredicates;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TaskContextHelperServiceImpl
implements TaskContextHelperService {
    private static final String PLAN = "plan";
    private static final String PLAN_KEY = "planKey";
    private static final String ENVIRONMENT = "environment";
    private static final String ENVIRONMENT_ID = "environmentId";
    private final BuildDefinitionManager buildDefinitionManager;
    private final EnvironmentService environmentService;

    public TaskContextHelperServiceImpl(BuildDefinitionManager buildDefinitionManager, EnvironmentService environmentService) {
        this.buildDefinitionManager = buildDefinitionManager;
        this.environmentService = environmentService;
    }

    @NotNull
    public List<TaskDefinition> getTasksBeforeTaskId(@NotNull Map<String, Object> context, long taskId) {
        List<TaskDefinition> tasks = this.getTasks(context);
        int taskIndex = Iterables.indexOf(tasks, TaskPredicates.hasTaskDefinitionEqualId(taskId));
        return tasks.subList(0, taskIndex);
    }

    @NotNull
    public List<TaskDefinition> getTasks(@NotNull Map<String, Object> context) {
        if (context.containsKey(PLAN)) {
            ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)context.get(PLAN), ImmutableJob.class);
            Preconditions.checkNotNull((Object)job, (Object)"Plan in task context is not a job");
            BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition(job.getPlanKey());
            return buildDefinition.getTaskDefinitions();
        }
        if (context.containsKey(ENVIRONMENT)) {
            Environment environment = (Environment)Narrow.downTo((Object)context.get(ENVIRONMENT), Environment.class);
            Preconditions.checkNotNull((Object)environment, (Object)"Environment in task context is null or not a job");
            return environment.getTaskDefinitions();
        }
        return ImmutableList.of();
    }

    @NotNull
    public List<TaskDefinition> getTasks(@NotNull ActionParametersMap params) {
        if (params.containsKey((Object)PLAN_KEY)) {
            PlanKey jobKey = PlanKeys.getPlanKey((String)params.getString(PLAN_KEY));
            BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition(jobKey);
            return buildDefinition.getTaskDefinitions();
        }
        if (params.containsKey((Object)ENVIRONMENT_ID)) {
            long environmentId = params.getLong(ENVIRONMENT_ID, -1L);
            Environment environment = this.environmentService.getEnvironment(environmentId);
            Preconditions.checkNotNull((Object)environment, (Object)("Environment in action params not found, environmentId: " + environmentId));
            return environment.getTaskDefinitions();
        }
        return ImmutableList.of();
    }
}

