/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.task.CommonTaskContextImpl;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskExecutionContext;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.BuildContext;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Internal
public class TaskContextImpl
extends CommonTaskContextImpl
implements TaskContext {
    public TaskContextImpl(Map<String, String> substitutedConfiguration, TaskExecutionContext taskExecutionContext, RuntimeTaskDefinition taskDefinition) {
        super(substitutedConfiguration, taskExecutionContext, taskDefinition);
    }

    @NotNull
    public BuildContext getBuildContext() {
        return this.taskExecutionContext.getBuildContext();
    }

    @Override
    @NotNull
    public File getRootDirectory() {
        switch (this.rootDirectorySelector.getTaskRootDirectoryType()) {
            case INHERITED: {
                return this.taskExecutionContext.getRootDirectory();
            }
            case DEFAULT: {
                return this.taskExecutionContext.getDefaultRootDirectory();
            }
            case REPOSITORY: {
                try {
                    Repository repository = ((RepositoryDefinition)this.getBuildContext().getRepositoryDefinitionMap().get(this.rootDirectorySelector.getRepositoryDefiningWorkingDirectory())).getRepository();
                    return repository.getSourceCodeDirectory(this.getBuildContext().getPlanResultKey().getPlanKey());
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalStateException("Don't know how to determine root working directory of task");
    }
}

