/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.atlassian.bamboo.utils.BambooInterners;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TaskDefinitionImpl
implements TaskDefinition {
    private final long id;
    private final String pluginKey;
    private String userDescription;
    private boolean isEnabled;
    private FinalArrayList<TaskConditionConfig> conditions;
    private FinalHashMap<String, String> configuration;
    private boolean finalising;
    private TaskRootDirectorySelector rootDirectorySelector;
    private BambooEntityOid oid;

    public TaskDefinitionImpl(long id, @NotNull String pluginKey, @Nullable String userDescription, @NotNull Map<String, String> taskConfigMap) {
        this(id, pluginKey, userDescription, true, taskConfigMap);
    }

    public TaskDefinitionImpl(long id, @NotNull String pluginKey, @Nullable String userDescription, boolean isEnabled, @NotNull Map<String, String> configuration) {
        this(id, pluginKey, userDescription, isEnabled, configuration, false, TaskRootDirectorySelector.INHERITED);
    }

    public TaskDefinitionImpl(long id, @NotNull String pluginKey, @Nullable String userDescription, boolean isEnabled, @NotNull Map<String, String> configuration, boolean finalising) {
        this(id, pluginKey, userDescription, isEnabled, configuration, finalising, TaskRootDirectorySelector.INHERITED);
    }

    public TaskDefinitionImpl(long id, @NotNull String pluginKey, @Nullable String userDescription, boolean isEnabled, @NotNull List<TaskConditionConfig> conditions, @NotNull Map<String, String> configuration, boolean finalising) {
        this(id, pluginKey, userDescription, isEnabled, conditions, configuration, finalising, TaskRootDirectorySelector.INHERITED);
    }

    public TaskDefinitionImpl(long id, @NotNull String pluginKey, @Nullable String userDescription, @NotNull Map<String, String> configuration, boolean finalising) {
        this(id, pluginKey, userDescription, true, Collections.emptyList(), configuration, finalising, TaskRootDirectorySelector.INHERITED);
    }

    public TaskDefinitionImpl(long id, @NotNull String pluginKey, @Nullable String userDescription, boolean isEnabled, @NotNull Map<String, String> configuration, boolean finalising, @NotNull TaskRootDirectorySelector taskRootDirectorySelector) {
        this(id, pluginKey, userDescription, isEnabled, Collections.emptyList(), configuration, finalising, taskRootDirectorySelector);
    }

    public TaskDefinitionImpl(long id, @NotNull String pluginKey, @Nullable String userDescription, boolean isEnabled, @NotNull List<TaskConditionConfig> conditions, @NotNull Map<String, String> configuration, boolean finalising, @NotNull TaskRootDirectorySelector taskRootDirectorySelector) {
        this.id = id;
        this.pluginKey = BambooInterners.moduleKey((String)pluginKey);
        this.setUserDescription(userDescription);
        this.isEnabled = isEnabled;
        this.conditions = new FinalArrayList(conditions);
        this.configuration = new FinalHashMap(configuration);
        this.finalising = finalising;
        this.rootDirectorySelector = taskRootDirectorySelector;
    }

    public long getId() {
        return this.id;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Nullable
    public String getUserDescription() {
        return this.userDescription;
    }

    public void setUserDescription(@Nullable String userDescription) {
        this.userDescription = BambooInterners.intern((String)userDescription);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @NotNull
    public List<TaskConditionConfig> getConditions() {
        return this.conditions;
    }

    public void setConditions(@NotNull List<TaskConditionConfig> conditions) {
        this.conditions = new FinalArrayList(conditions);
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@NotNull Map<String, String> configuration) {
        this.configuration = new FinalHashMap(configuration);
    }

    public boolean isFinalising() {
        return this.finalising;
    }

    public void setFinalising(boolean finalising) {
        this.finalising = finalising;
    }

    @NotNull
    public TaskRootDirectorySelector getRootDirectorySelector() {
        return this.rootDirectorySelector;
    }

    public void setRootDirectorySelector(@NotNull TaskRootDirectorySelector rootDirectorySelector) {
        this.rootDirectorySelector = rootDirectorySelector;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)this.pluginKey).append((Object)this.userDescription).append(this.id).append(this.configuration).append(this.conditions).append(this.finalising).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TaskDefinitionImpl)) {
            return false;
        }
        TaskDefinitionImpl rhs = (TaskDefinitionImpl)o;
        return new EqualsBuilder().append((Object)this.pluginKey, (Object)rhs.pluginKey).append((Object)this.userDescription, (Object)rhs.userDescription).append(this.id, rhs.id).append(this.configuration, rhs.configuration).append(this.conditions, rhs.conditions).append(this.finalising, rhs.finalising).isEquals();
    }

    public int compareTo(Object obj) {
        TaskDefinitionImpl o = (TaskDefinitionImpl)obj;
        return new CompareToBuilder().append((Object)this.pluginKey, (Object)o.pluginKey).append((Object)this.userDescription, (Object)o.userDescription).append(this.id, o.id).append(this.configuration, o.configuration).append(this.conditions, o.conditions).append(this.finalising, o.finalising).toComparison();
    }

    public String toString() {
        return this.pluginKey + " " + this.userDescription;
    }

    public void setOid(BambooEntityOid oid) {
        this.oid = oid;
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }
}

