/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.task.TaskExecutableType;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TaskExecutableTypeImpl
implements TaskExecutableType {
    private static final Logger log = Logger.getLogger(TaskExecutableTypeImpl.class);
    private final String executableKey;
    private final String i18nExecutableNameKey;
    private final String i18nPathHelpKey;
    private final boolean primaryCapabilityProvider;

    public TaskExecutableTypeImpl(@NotNull Attribute key, @Nullable Attribute nameKey, @Nullable Attribute pathHelpKey, @Nullable Attribute primaryCapabilityProvider) {
        Preconditions.checkNotNull((Object)key, (Object)"key attribute should not be null");
        this.executableKey = key.getValue();
        this.i18nExecutableNameKey = TaskExecutableTypeImpl.getAttributeValueSafely(nameKey);
        this.i18nPathHelpKey = TaskExecutableTypeImpl.getAttributeValueSafely(pathHelpKey);
        String value = TaskExecutableTypeImpl.getAttributeValueSafely(primaryCapabilityProvider);
        this.primaryCapabilityProvider = StringUtils.isNotEmpty((CharSequence)value) ? Boolean.parseBoolean(value) : true;
    }

    @NotNull
    public String getExecutableKey() {
        return this.executableKey;
    }

    public String getI18nExecutableNameKey() {
        return this.i18nExecutableNameKey;
    }

    public String getI18nPathHelpKey() {
        return this.i18nPathHelpKey;
    }

    public boolean isPrimaryCapabilityProvider() {
        return this.primaryCapabilityProvider;
    }

    static String getAttributeValueSafely(@Nullable Attribute attribute) {
        return attribute != null ? attribute.getValue() : null;
    }
}

