/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.task.TaskExecutionStrategy;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import java.io.File;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TaskExecutionContext {
    private static final Logger log = Logger.getLogger(TaskExecutionContext.class);
    private final CommonContext commonContext;
    private final DeploymentContext deploymentContext;
    private final BuildContext buildContext;
    private final ReadOnlyCapabilitySet capabilities;
    private final TaskExecutionStrategy executionStrategy;
    private final BuildLogger buildLogger;
    private final Queue<RuntimeTaskDefinition> tasks;
    private final File defaultRootDirectory;

    public TaskExecutionContext(Queue<RuntimeTaskDefinition> tasks, TaskExecutionStrategy executionStrategy, @NotNull CommonContext commonContext, ReadOnlyCapabilitySet capabilities, BuildLoggerManager buildLoggerManager, File defaultRootDirectory) {
        this.tasks = tasks;
        this.buildContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class);
        this.commonContext = commonContext;
        this.deploymentContext = (DeploymentContext)Narrow.downTo((Object)commonContext, DeploymentContext.class);
        this.capabilities = capabilities;
        this.executionStrategy = executionStrategy;
        this.defaultRootDirectory = defaultRootDirectory;
        this.buildLogger = buildLoggerManager.getLogger(commonContext.getResultKey());
    }

    public boolean hasTasksToExecute(@Nullable TaskResult taskResult) {
        return this.executionStrategy.hasTasksToExecute(this.tasks, taskResult);
    }

    public RuntimeTaskDefinition getNextTaskToExecute() {
        return this.executionStrategy.nextTask(this.tasks);
    }

    @Nullable
    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    @NotNull
    public CommonContext getCommonContext() {
        return this.commonContext;
    }

    @Nullable
    public DeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    @NotNull
    public ReadOnlyCapabilitySet getCapabilities() {
        return this.capabilities;
    }

    @NotNull
    public BuildLogger getBuildLogger() {
        return this.buildLogger;
    }

    @NotNull
    public File getRootDirectory() {
        return BuildContextHelper.getBuildWorkingDirectory(this.buildContext);
    }

    @NotNull
    public File getDefaultRootDirectory() {
        return this.defaultRootDirectory;
    }
}

