/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskType;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plugin.descriptor.TaskConditionModuleDescriptor;
import com.atlassian.bamboo.process.BackgroundTaskProcesses;
import com.atlassian.bamboo.process.ProcessContext;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskContextImpl;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.DefaultTaskExecutionStrategy;
import com.atlassian.bamboo.task.DeploymentTaskContextImpl;
import com.atlassian.bamboo.task.FinalizingTaskExecutionStrategy;
import com.atlassian.bamboo.task.InternalTaskType;
import com.atlassian.bamboo.task.PreparationTask;
import com.atlassian.bamboo.task.TaskActionExecutor;
import com.atlassian.bamboo.task.TaskConditionConfig;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskContextImpl;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskExecutionContext;
import com.atlassian.bamboo.task.TaskExecutor;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskPredicates;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskResultProcessor;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.task.condition.TaskCondition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TaskExecutorImpl
implements TaskExecutor {
    private static final Logger log = Logger.getLogger(TaskExecutorImpl.class);
    private final ErrorUpdateHandler errorUpdateHandler;
    private final BuildLoggerManager buildLoggerManager;
    private final PluginAccessor pluginAccessor;
    private final CustomVariableContext customVariableContext;
    private final BuildDirectoryManager buildDirectoryManager;
    private final TaskActionExecutor taskActionExecutor;
    private final TaskResultProcessor quarantineTaskResultProcessor;
    @Inject
    private ProcessService processService;

    public TaskExecutorImpl(ErrorUpdateHandler errorUpdateHandler, BuildLoggerManager buildLoggerManager, PluginAccessor pluginAccessor, CustomVariableContext customVariableContext, BuildDirectoryManager buildDirectoryManager, TaskActionExecutor taskActionExecutor, TaskResultProcessor quarantineTaskResultProcessor) {
        this.errorUpdateHandler = errorUpdateHandler;
        this.buildLoggerManager = buildLoggerManager;
        this.pluginAccessor = pluginAccessor;
        this.customVariableContext = customVariableContext;
        this.buildDirectoryManager = buildDirectoryManager;
        this.quarantineTaskResultProcessor = quarantineTaskResultProcessor;
        this.taskActionExecutor = taskActionExecutor;
    }

    @NotNull
    public List<TaskResult> executePreparationTasks(@NotNull CommonContext buildContext, @NotNull ReadOnlyCapabilitySet readOnlyCapabilitySet) {
        ArrayList<TaskResult> taskResults = new ArrayList<TaskResult>();
        TaskExecutionContext taskExecutionContext = this.preparePreTaskExecutionContext(buildContext, readOnlyCapabilitySet);
        this.executeTasks(buildContext, taskExecutionContext, taskResults);
        return taskResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<TaskResult> execute(@NotNull CommonContext buildContext, @NotNull ReadOnlyCapabilitySet readOnlyCapabilitySet) {
        ArrayList<TaskResult> taskResults = new ArrayList<TaskResult>();
        ResultKey resultKey = buildContext.getResultKey();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(resultKey);
        if (buildContext.getRuntimeTaskDefinitions().isEmpty()) {
            String errorMessage = "No tasks to execute in " + buildContext.getDisplayName();
            this.errorUpdateHandler.recordError(resultKey, errorMessage, null);
            buildLogger.addErrorLogEntry(errorMessage);
            return taskResults;
        }
        TaskExecutionContext taskExecutionContext = this.prepareTaskExecutionContext(buildContext, readOnlyCapabilitySet, false);
        TaskExecutionContext finalizingTaskExecutionContext = this.prepareTaskExecutionContext(buildContext, readOnlyCapabilitySet, true);
        try {
            this.initialiseTasks(buildContext);
            this.executeTasks(buildContext, taskExecutionContext, taskResults);
        }
        catch (Throwable throwable) {
            boolean jobFailed = !taskResults.isEmpty() && ((TaskResult)Iterables.getLast(taskResults)).getTaskState() != TaskState.SUCCESS;
            buildContext.getVariableContext().addLocalVariable("jobFailed", Boolean.toString(jobFailed));
            if (jobFailed && buildContext.getVariableContext().getEffectiveVariables().containsKey("buildFailed")) {
                buildContext.getVariableContext().addLocalVariable("buildFailed", Boolean.TRUE.toString());
            }
            try {
                this.executeTasks(buildContext, finalizingTaskExecutionContext, taskResults);
                throw throwable;
            }
            finally {
                this.handleBackgroundProcesses(this.processService.getBackgroundProcesses().of(buildContext.getBuildKey()), taskResults, buildLogger);
                this.finaliseTasks(buildContext);
            }
        }
        boolean jobFailed = !taskResults.isEmpty() && ((TaskResult)Iterables.getLast(taskResults)).getTaskState() != TaskState.SUCCESS;
        buildContext.getVariableContext().addLocalVariable("jobFailed", Boolean.toString(jobFailed));
        if (jobFailed && buildContext.getVariableContext().getEffectiveVariables().containsKey("buildFailed")) {
            buildContext.getVariableContext().addLocalVariable("buildFailed", Boolean.TRUE.toString());
        }
        try {
            this.executeTasks(buildContext, finalizingTaskExecutionContext, taskResults);
            return taskResults;
        }
        finally {
            this.handleBackgroundProcesses(this.processService.getBackgroundProcesses().of(buildContext.getBuildKey()), taskResults, buildLogger);
            this.finaliseTasks(buildContext);
        }
    }

    private void initialiseTasks(@NotNull CommonContext commonContext) {
        for (RuntimeTaskDefinition runtimeTaskDefinition : commonContext.getRuntimeTaskDefinitions()) {
            TaskModuleDescriptor moduleDescriptor = (TaskModuleDescriptor)Narrow.to((Object)this.pluginAccessor.getEnabledPluginModule(runtimeTaskDefinition.getPluginKey()), TaskModuleDescriptor.class);
            if (moduleDescriptor == null || moduleDescriptor.getTaskBackgroundProcessor() == null) continue;
            String taskName = StringUtils.isNotBlank((CharSequence)runtimeTaskDefinition.getUserDescription()) ? runtimeTaskDefinition.getUserDescription() : runtimeTaskDefinition.getPluginKey();
            log.info((Object)String.format("Initialising background processor for task %s", taskName));
            moduleDescriptor.getTaskBackgroundProcessor().initProcessing(runtimeTaskDefinition, commonContext);
            log.debug((Object)String.format("END Initialising background processor for task %s", taskName));
        }
    }

    private void finaliseTasks(@NotNull CommonContext commonContext) {
        ImmutableList tasksReversed = ImmutableList.copyOf((Collection)commonContext.getRuntimeTaskDefinitions()).reverse();
        for (RuntimeTaskDefinition runtimeTaskDefinition : tasksReversed) {
            TaskModuleDescriptor moduleDescriptor = (TaskModuleDescriptor)Narrow.to((Object)this.pluginAccessor.getEnabledPluginModule(runtimeTaskDefinition.getPluginKey()), TaskModuleDescriptor.class);
            if (moduleDescriptor == null || moduleDescriptor.getTaskBackgroundProcessor() == null) continue;
            String taskName = StringUtils.isNotBlank((CharSequence)runtimeTaskDefinition.getUserDescription()) ? runtimeTaskDefinition.getUserDescription() : runtimeTaskDefinition.getPluginKey();
            log.info((Object)String.format("Finalising background processor for task %s", taskName));
            moduleDescriptor.getTaskBackgroundProcessor().finaliseProcessing(runtimeTaskDefinition, commonContext);
            log.debug((Object)String.format("END Finalising background processor for task %s", taskName));
        }
    }

    private void handleBackgroundProcesses(BackgroundTaskProcesses.BackgroundTaskProcessesFacade backgroundProcesses, List<TaskResult> taskResults, BuildLogger buildLogger) {
        Map killedProcesses = backgroundProcesses.cancel();
        if (killedProcesses.isEmpty()) {
            return;
        }
        for (Map.Entry processesOfTasks : killedProcesses.entrySet()) {
            ExternalProcess process = (ExternalProcess)processesOfTasks.getKey();
            ProcessContext task = (ProcessContext)processesOfTasks.getValue();
            String startedByTask = "started by ";
            startedByTask = StringUtils.isNotBlank((CharSequence)task.getTaskDescription()) ? startedByTask + task.getTaskDescription() + ' ' : startedByTask + "an unnamed task " + task.getTaskId() + ' ';
            buildLogger.addErrorLogEntry("Build will fail: [" + process.getCommandLine() + "] " + startedByTask + "is still running, killed.");
        }
        buildLogger.addErrorLogEntry("Failing build. All processes started within a build must be terminated within a build.");
        Set tasksToFail = killedProcesses.values().stream().map(ProcessContext::getTaskId).collect(Collectors.toSet());
        taskResults.replaceAll(taskResult -> tasksToFail.contains(taskResult.getTaskIdentifier().getId()) ? TaskResultBuilder.copyWithNewState((TaskResult)taskResult, (TaskState)TaskState.ERROR) : taskResult);
    }

    @NotNull
    public List<TaskResult> executeFinalTasks(@NotNull CommonContext commonContext, @NotNull ReadOnlyCapabilitySet readOnlyCapabilitySet) {
        ArrayList<TaskResult> taskResults = new ArrayList<TaskResult>();
        TaskExecutionContext finalizingTaskExecutionContext = this.prepareTaskExecutionContext(commonContext, readOnlyCapabilitySet, true);
        this.executeTasks(commonContext, finalizingTaskExecutionContext, taskResults);
        return taskResults;
    }

    private TaskExecutionContext preparePreTaskExecutionContext(@NotNull CommonContext commonContext, @NotNull ReadOnlyCapabilitySet readOnlyCapabilitySet) {
        RuntimeTaskDefinition taskDefinition;
        TaskModuleDescriptor moduleDescriptor;
        LinkedList<RuntimeTaskDefinition> firstSetOfPreparationTasks = new LinkedList<RuntimeTaskDefinition>();
        Iterator iterator = commonContext.getRuntimeTaskDefinitions().iterator();
        while (iterator.hasNext() && (moduleDescriptor = (TaskModuleDescriptor)Narrow.to((Object)this.pluginAccessor.getEnabledPluginModule((taskDefinition = (RuntimeTaskDefinition)iterator.next()).getPluginKey()), TaskModuleDescriptor.class)) != null && PreparationTask.class.isAssignableFrom(moduleDescriptor.getModuleClass())) {
            firstSetOfPreparationTasks.add(taskDefinition);
        }
        return new TaskExecutionContext(firstSetOfPreparationTasks, new DefaultTaskExecutionStrategy(), commonContext, readOnlyCapabilitySet, this.buildLoggerManager, this.buildDirectoryManager.getBuildWorkingDirectory(commonContext.getEntityKey()));
    }

    private TaskExecutionContext prepareTaskExecutionContext(@NotNull CommonContext commonContext, @NotNull ReadOnlyCapabilitySet readOnlyCapabilitySet, boolean isFinalizing) {
        LinkedList tasks = new LinkedList();
        if (Iterables.isEmpty((Iterable)commonContext.getCurrentResult().getTaskResults())) {
            tasks.addAll(commonContext.getRuntimeTaskDefinitions());
        } else {
            RuntimeTaskDefinition taskDefinition;
            TaskResult lastExecutedTaskResult = (TaskResult)Iterables.getLast((Iterable)commonContext.getCurrentResult().getTaskResults());
            long lastExecutedTaskResultId = lastExecutedTaskResult.getTaskIdentifier().getId();
            Iterator tasksIterator = commonContext.getRuntimeTaskDefinitions().iterator();
            while (tasksIterator.hasNext() && (taskDefinition = (RuntimeTaskDefinition)tasksIterator.next()).getId() != lastExecutedTaskResultId) {
            }
            while (tasksIterator.hasNext()) {
                tasks.add(tasksIterator.next());
            }
        }
        return new TaskExecutionContext(Lists.newLinkedList((Iterable)Iterables.filter(tasks, TaskPredicates.isFinalisingEqual(isFinalizing))), isFinalizing ? new FinalizingTaskExecutionStrategy() : new DefaultTaskExecutionStrategy(), commonContext, readOnlyCapabilitySet, this.buildLoggerManager, this.buildDirectoryManager.getBuildWorkingDirectory(commonContext.getEntityKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult executeTaskWithPrePostActions(@NotNull InternalTaskType task, @NotNull CommonTaskContext context, @NotNull Callable<TaskResult> runTask) throws Exception {
        TaskResult taskResult = null;
        List taskActions = Collections.emptyList();
        try {
            taskActions = this.taskActionExecutor.executePreTaskActions(task, context);
            taskResult = runTask.call();
        }
        catch (Throwable throwable) {
            taskActions = Lists.reverse(new LinkedList(taskActions));
            taskResult = this.taskActionExecutor.executePostTaskActions(task, taskResult, taskActions);
            throw throwable;
        }
        taskActions = Lists.reverse(new LinkedList(taskActions));
        taskResult = this.taskActionExecutor.executePostTaskActions(task, taskResult, taskActions);
        return taskResult;
    }

    private void executeTasks(@NotNull CommonContext commonContext, @NotNull TaskExecutionContext taskExecutionContext, @NotNull List<TaskResult> taskResults) {
        ResultKey resultKey = taskExecutionContext.getCommonContext().getResultKey();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(taskExecutionContext.getCommonContext().getResultKey());
        TaskResult taskResult = null;
        while (taskExecutionContext.hasTasksToExecute(taskResult)) {
            block14: {
                RuntimeTaskDefinition taskDefinition;
                if (taskResult != null && taskResult.getTaskState() != TaskState.SUCCESS) {
                    commonContext.getVariableContext().addLocalVariable("jobFailed", Boolean.TRUE.toString());
                }
                if (!(taskDefinition = taskExecutionContext.getNextTaskToExecute()).isEnabled()) {
                    log.info((Object)buildLogger.addBuildLogEntry(String.format("Skipping execution of task '%s' as it is disabled", StringUtils.isNotEmpty((CharSequence)taskDefinition.getUserDescription()) ? taskDefinition.getUserDescription() : taskDefinition.getPluginKey())));
                    continue;
                }
                if (!taskDefinition.getConditions().isEmpty() && !this.isConditionsMet(taskDefinition, commonContext, buildLogger)) {
                    buildLogger.addBuildLogEntry("Found conditional task: " + taskDefinition.toString() + ". Skipping task because conditions were not met.");
                    continue;
                }
                Map<String, String> substitutedConfiguration = this.substituteConfigurationVariables(taskDefinition.getConfiguration());
                TaskModuleDescriptor moduleDescriptor = (TaskModuleDescriptor)Narrow.to((Object)this.pluginAccessor.getEnabledPluginModule(taskDefinition.getPluginKey()), TaskModuleDescriptor.class);
                if (moduleDescriptor != null) {
                    InternalTaskType task = (InternalTaskType)moduleDescriptor.getModule();
                    String taskName = StringUtils.isNotEmpty((CharSequence)taskDefinition.getUserDescription()) ? taskDefinition.getUserDescription() : moduleDescriptor.getName();
                    log.info((Object)buildLogger.addBuildLogEntry(String.format("Starting task '%s' of type '%s'", taskName, taskDefinition.getPluginKey())));
                    CommonTaskContext taskContext = this.getTaskContext(substitutedConfiguration, taskExecutionContext, taskDefinition, commonContext.getClass());
                    try {
                        Map runtimeTaskContext = taskContext.getRuntimeTaskContext();
                        if (runtimeTaskContext != null) {
                            Map<String, String> substitutedRuntimeConfiguration = this.substituteConfigurationVariables(runtimeTaskContext);
                            runtimeTaskContext.clear();
                            runtimeTaskContext.putAll(substitutedRuntimeConfiguration);
                        }
                        CommonTaskType commonTask = (CommonTaskType)Narrow.downTo((Object)task, CommonTaskType.class);
                        DeploymentTaskContext deploymentTaskContext = (DeploymentTaskContext)Narrow.downTo((Object)taskContext, DeploymentTaskContext.class);
                        DeploymentTaskType deploymentTask = (DeploymentTaskType)Narrow.downTo((Object)task, DeploymentTaskType.class);
                        TaskContext buildTaskContext = (TaskContext)Narrow.downTo((Object)taskContext, TaskContext.class);
                        TaskType buildTask = (TaskType)Narrow.downTo((Object)task, TaskType.class);
                        taskResult = deploymentTaskContext != null && deploymentTask != null ? this.executeTaskWithPrePostActions((InternalTaskType)deploymentTask, (CommonTaskContext)deploymentTaskContext, () -> deploymentTask.execute(deploymentTaskContext)) : (buildTaskContext != null && buildTask != null ? this.executeTaskWithPrePostActions((InternalTaskType)buildTask, (CommonTaskContext)buildTaskContext, () -> buildTask.execute(buildTaskContext)) : (commonTask != null ? this.executeTaskWithPrePostActions((InternalTaskType)commonTask, taskContext, () -> commonTask.execute(taskContext)) : this.getFailedTaskResult("Incorrect task class: " + task.getClass().getName(), resultKey, (TaskDefinition)taskDefinition, buildLogger)));
                        if (buildTaskContext != null) {
                            TaskState newTaskState = this.quarantineTaskResultProcessor.recalculateTaskState(buildTaskContext, taskResult, (TaskDefinition)taskDefinition);
                            taskResult = TaskResultBuilder.copyWithNewState((TaskResult)taskResult, (TaskState)newTaskState);
                        }
                        buildLogger.getInterceptorStack().clear();
                        if (taskResult != null) {
                            buildLogger.addBuildLogEntry("Finished task '" + taskName + "' with result: " + taskResult.getTaskState());
                        } else {
                            buildLogger.addBuildLogEntry("Finished task '" + taskName + "' without any result...");
                        }
                        if (BuildUtils.isDevMode() || log.isDebugEnabled()) {
                            buildLogger.addBuildLogEntry("Finished task " + taskDefinition);
                        }
                    }
                    catch (Throwable e) {
                        String errorMessage;
                        Iterable cancelExceptions = Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), CancelException.class);
                        if (!Iterables.isEmpty((Iterable)cancelExceptions)) {
                            errorMessage = "Task was canceled - '" + taskDefinition.getUserDescription() + "(" + taskDefinition.getId() + ")' of type " + taskDefinition.getPluginKey() + ".";
                            buildLogger.addBuildLogEntry(errorMessage);
                            log.debug((Object)errorMessage, e);
                            taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
                            break block14;
                        }
                        errorMessage = "Error occurred while running Task '" + taskDefinition.getUserDescription() + "(" + taskDefinition.getId() + ")' of type " + taskDefinition.getPluginKey() + ".";
                        taskResult = this.getFailedTaskResult(errorMessage, resultKey, (TaskDefinition)taskDefinition, buildLogger, e);
                    }
                } else {
                    String taskDescription = StringUtils.isBlank((CharSequence)taskDefinition.getUserDescription()) ? "" : "'" + taskDefinition.getUserDescription() + "'";
                    taskResult = this.getFailedTaskResult("Could not execute task " + taskDescription + " no Plugin with key '" + taskDefinition.getPluginKey() + "' is installed.", resultKey, (TaskDefinition)taskDefinition, buildLogger);
                }
            }
            taskResults.add(taskResult);
        }
    }

    private boolean isConditionsMet(RuntimeTaskDefinition taskDefinition, CommonContext commonContext, BuildLogger buildLogger) throws IllegalStateException {
        for (TaskConditionConfig condition : taskDefinition.getConditions()) {
            String conditionPluginKey = condition.getConditionPluginKey();
            TaskConditionModuleDescriptor taskCondition = (TaskConditionModuleDescriptor)Narrow.downTo((Object)this.pluginAccessor.getEnabledPluginModule(conditionPluginKey), TaskConditionModuleDescriptor.class);
            if (taskCondition == null) {
                log.warn((Object)buildLogger.addBuildLogEntry("Can't find condition " + conditionPluginKey + ", stop task execution" + taskDefinition.getPluginKey()));
                throw new IllegalStateException("Can't find condition " + conditionPluginKey);
            }
            if (((TaskCondition)taskCondition.getModule()).isMet(taskDefinition, condition.getConfiguration(), commonContext)) continue;
            buildLogger.addBuildLogEntry("Condition " + condition.getConditionPluginKey() + " wasn't met. Skipping task.");
            return false;
        }
        return true;
    }

    @NotNull
    private CommonTaskContext getTaskContext(Map<String, String> substitutedConfiguration, TaskExecutionContext taskExecutionContext, RuntimeTaskDefinition taskDefinition, Class<? extends CommonContext> contextClass) {
        if (BuildContext.class.isAssignableFrom(contextClass)) {
            return new TaskContextImpl(substitutedConfiguration, taskExecutionContext, taskDefinition);
        }
        if (DeploymentContext.class.isAssignableFrom(contextClass)) {
            return new DeploymentTaskContextImpl(substitutedConfiguration, taskExecutionContext, taskDefinition);
        }
        return new CommonTaskContextImpl(substitutedConfiguration, taskExecutionContext, taskDefinition);
    }

    private Map<String, String> substituteConfigurationVariables(Map<String, String> configuration) {
        HashMap<String, String> substitutedConfiguration = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            substitutedConfiguration.put(entry.getKey(), this.customVariableContext.substituteString(entry.getValue()));
        }
        return substitutedConfiguration;
    }

    private TaskResult getFailedTaskResult(String errorMessage, ResultKey resultKey, TaskDefinition taskDefinition, BuildLogger buildLogger) {
        return this.getFailedTaskResult(errorMessage, resultKey, taskDefinition, buildLogger, null);
    }

    private TaskResult getFailedTaskResult(String errorMessage, ResultKey resultKey, TaskDefinition taskDefinition, BuildLogger buildLogger, @Nullable Throwable e) {
        log.error((Object)errorMessage, e);
        this.errorUpdateHandler.recordError(resultKey, errorMessage, e);
        buildLogger.addErrorLogEntry(errorMessage, e);
        return TaskResultBuilder.createFailedWithErrorResult((TaskIdentifier)taskDefinition);
    }
}

