/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.agent.elastic.server.ElasticAccountBean;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskType;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.InternalTaskType;
import com.atlassian.bamboo.task.TaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskExecutableType;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.task.TaskRootDirectorySelector;
import com.atlassian.bamboo.task.TaskRootDirectoryType;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.task.repository.RepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.FixedDirectoryWorkingCopyManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServerSideOnly
@Internal
public class TaskManagerImpl
implements TaskManager {
    public static final Requirement DOCKERBOX_REQUIREMENT = new RequirementImpl("system.docker.executable", true, ".*", true);
    private final PluginAccessor pluginAccessor;
    private final CapabilitySetManager capabilitySetManager;
    private final ElasticAccountBean elasticAccountBean;
    private final VcsRepositoryManager vcsRepositoryManager;
    private static Predicate<TaskModuleDescriptor> IsDeploymentTaskDescriptorPredicate = new IsTaskDescriptorOfTaskType(DeploymentTaskType.class);
    private static Predicate<TaskModuleDescriptor> IsBuildTaskDescriptorPredicate = new IsTaskDescriptorOfTaskType(TaskType.class);

    public TaskManagerImpl(PluginAccessor pluginAccessor, CapabilitySetManager capabilitySetManager, ElasticAccountBean elasticAccountBean, VcsRepositoryManager vcsRepositoryManager) {
        this.pluginAccessor = pluginAccessor;
        this.capabilitySetManager = capabilitySetManager;
        this.elasticAccountBean = elasticAccountBean;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @Nullable
    public TaskModuleDescriptor getTaskDescriptor(@Nullable String pluginKey) {
        if (StringUtils.isNotEmpty((CharSequence)pluginKey)) {
            ModuleDescriptor descriptor = this.pluginAccessor.getEnabledPluginModule(pluginKey);
            return (TaskModuleDescriptor)Narrow.reinterpret((Object)descriptor, TaskModuleDescriptor.class);
        }
        return null;
    }

    @NotNull
    public List<TaskModuleDescriptor> getAvailableTaskDescriptors() {
        return Comparators.getModuleDescriptorNameOrdering().sortedCopy((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(TaskModuleDescriptor.class));
    }

    @NotNull
    public List<TaskModuleDescriptor> getAvailableBuildTaskDescriptors() {
        return this.getAvailableTaskDescriptors(IsBuildTaskDescriptorPredicate);
    }

    @NotNull
    public List<TaskModuleDescriptor> getAvailableDeploymentTaskDescriptors() {
        return this.getAvailableTaskDescriptors(IsDeploymentTaskDescriptorPredicate);
    }

    public void calculateRequirementsForTaskDefinition(@NotNull Job job, @NotNull TaskDefinition taskDefinition) {
        RequirementSet buildableRequirementSet = job.getRequirementSet();
        this.calculateRequirementsForTaskDefinition(buildableRequirementSet, taskDefinition, this.getJobRequirementsSupplier(job, taskDefinition), job.getBuildDefinition().getDockerPipelineConfiguration().isEnabled());
    }

    public void calculateRequirementsForTaskDefinition(@NotNull RequirementSet requirementSet, @NotNull TaskDefinition taskDefinition, Supplier<Set<Requirement>> requirementSupplier) {
        this.calculateRequirementsForTaskDefinition(requirementSet, taskDefinition, requirementSupplier, false);
    }

    public void calculateRequirementsForTaskDefinition(@NotNull RequirementSet requirementSet, @NotNull TaskDefinition taskDefinition, Supplier<Set<Requirement>> requirementSupplier, boolean dockerPipelinesEnabled) {
        Set<Object> calculatedRequirements;
        long ownerId = taskDefinition.getId();
        String pluginKey = taskDefinition.getPluginKey();
        if (taskDefinition.isEnabled()) {
            if (dockerPipelinesEnabled) {
                calculatedRequirements = Collections.singleton(this.createDockerRequirement());
            } else {
                calculatedRequirements = requirementSupplier.get();
                if (calculatedRequirements == null) {
                    calculatedRequirements = new HashSet();
                }
                this.setTaskRequirementSystemProperties(taskDefinition, calculatedRequirements);
            }
        } else {
            calculatedRequirements = new HashSet();
        }
        Set existingPluginRequirements = requirementSet.getRequirementsForPlugin(pluginKey, ownerId);
        requirementSet.removeRequirements((Iterable)existingPluginRequirements);
        if (!dockerPipelinesEnabled) {
            this.removeDockerBoxRequirement(requirementSet);
        }
        requirementSet.addAllRequirements(calculatedRequirements);
    }

    public void removeRequirementsForTaskDefinition(@NotNull Buildable buildable, @NotNull TaskDefinition taskDefinition) {
        RequirementSet buildableRequirementSet = buildable.getRequirementSet();
        this.removeRequirementsForTaskDefinition(buildableRequirementSet, taskDefinition);
    }

    public void removeRequirementsForTaskDefinition(@NotNull RequirementSet requirementSet, @NotNull TaskDefinition taskDefinition) {
        long id = taskDefinition.getId();
        String pluginKey = taskDefinition.getPluginKey();
        Set existingPluginRequirements = requirementSet.getRequirementsForPlugin(pluginKey, id);
        requirementSet.removeRequirements((Iterable)existingPluginRequirements);
    }

    @NotNull
    private Supplier<Set<Requirement>> getJobRequirementsSupplier(final @NotNull Job job, final @NotNull TaskDefinition taskDefinition) {
        return new Supplier<Set<Requirement>>(){

            @Override
            public Set<Requirement> get() {
                TaskModuleDescriptor taskModuleDescriptor = TaskManagerImpl.this.getTaskDescriptor(taskDefinition.getPluginKey());
                if (taskModuleDescriptor != null) {
                    TaskConfigurator taskConfigurator = taskModuleDescriptor.getTaskConfigurator();
                    TaskRequirementSupport taskRequirementSupport = (TaskRequirementSupport)Narrow.to((Object)taskConfigurator, TaskRequirementSupport.class);
                    if (taskRequirementSupport != null) {
                        return taskRequirementSupport.calculateRequirements(taskDefinition);
                    }
                    BuildTaskRequirementSupport jobTaskRequirementSupport = (BuildTaskRequirementSupport)Narrow.to((Object)taskConfigurator, BuildTaskRequirementSupport.class);
                    if (jobTaskRequirementSupport != null) {
                        return jobTaskRequirementSupport.calculateRequirements(taskDefinition, job);
                    }
                }
                return new HashSet<Requirement>();
            }
        };
    }

    private void setTaskRequirementSystemProperties(@NotNull TaskDefinition taskDefinition, @NotNull Set<Requirement> requirements) {
        long ownerId = taskDefinition.getId();
        String pluginKey = taskDefinition.getPluginKey();
        for (Requirement requirement : requirements) {
            requirement.setReadonly(Boolean.valueOf(true));
            requirement.setPluginModuleKey(pluginKey);
            requirement.setOwnerId(ownerId);
        }
    }

    public void updateRepositoryIdsInTask(@NotNull TaskDefinition taskDefinition, @NotNull Map<Long, Long> repositoryIdChanges) {
        RepositoryAwareTaskConfigurator taskConfigurator;
        TaskModuleDescriptor taskModuleDescriptor = this.getTaskDescriptor(taskDefinition.getPluginKey());
        if (taskModuleDescriptor != null && (taskConfigurator = (RepositoryAwareTaskConfigurator)Narrow.to((Object)taskModuleDescriptor.getTaskConfigurator(), RepositoryAwareTaskConfigurator.class)) != null) {
            taskConfigurator.handleRepositoryIdChanged(taskDefinition, repositoryIdChanges);
        }
    }

    public void updateWorkingDirSelectors(@NotNull ImmutableBuildable job, @NotNull BuildDefinition buildDefinition, @NotNull Map<Long, Long> repositoryIdsChanges) {
        List tasks = buildDefinition.getTaskDefinitions();
        long jobWorkingDirSelector = buildDefinition.getRepositoryIdDefiningWorkingDir();
        if (repositoryIdsChanges.containsKey(jobWorkingDirSelector)) {
            jobWorkingDirSelector = repositoryIdsChanges.get(jobWorkingDirSelector);
        }
        int repositoryCounter = 0;
        HashSet<Long> notCustomDirectoryAwareIds = new HashSet<Long>();
        for (TaskDefinition taskDefinition : BambooPluginUtils.filterEnabledTasks(tasks, "com.atlassian.bamboo.plugins.vcs:task.vcs.checkout")) {
            for (PlanRepositoryDefinition repositoryDefinition : RepositoryTaskHelper.safeGetPlanRepositoriesUsedByTask(taskDefinition, PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)job))) {
                ++repositoryCounter;
                VcsRepositoryModuleDescriptor descriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
                if (descriptor == null || !FixedDirectoryWorkingCopyManager.class.isAssignableFrom(descriptor.getModuleClass())) continue;
                notCustomDirectoryAwareIds.add(repositoryDefinition.getId());
            }
        }
        if (repositoryCounter == 1 && !notCustomDirectoryAwareIds.isEmpty()) {
            jobWorkingDirSelector = (Long)Iterables.getFirst(notCustomDirectoryAwareIds, (Object)-1L);
        } else if (!notCustomDirectoryAwareIds.contains(jobWorkingDirSelector)) {
            jobWorkingDirSelector = -1L;
        }
        buildDefinition.setRepositoryIdDefiningWorkingDir(jobWorkingDirSelector);
        for (TaskDefinition taskDefinition : tasks) {
            if (taskDefinition.getRootDirectorySelector().getTaskRootDirectoryType() != TaskRootDirectoryType.REPOSITORY) continue;
            long taskRepositorySelector = taskDefinition.getRootDirectorySelector().getRepositoryDefiningWorkingDirectory();
            if (repositoryIdsChanges.containsKey(taskRepositorySelector)) {
                taskRepositorySelector = repositoryIdsChanges.get(taskRepositorySelector);
            }
            if (notCustomDirectoryAwareIds.contains(taskRepositorySelector)) {
                taskDefinition.setRootDirectorySelector(new TaskRootDirectorySelector(TaskRootDirectoryType.REPOSITORY, taskRepositorySelector));
                continue;
            }
            taskDefinition.setRootDirectorySelector(TaskRootDirectorySelector.INHERITED);
        }
    }

    @NotNull
    public Collection<Requirement> getTasksRequirements(@NotNull Job job) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (TaskDefinition definition : job.getBuildDefinition().getTaskDefinitions()) {
            Set<Requirement> calculatedRequirements = this.getJobRequirementsSupplier(job, definition).get();
            this.setTaskRequirementSystemProperties(definition, calculatedRequirements);
            requirements.addAll(calculatedRequirements);
        }
        return requirements;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        TaskTestResultsSupport taskConfigurator;
        TaskModuleDescriptor taskModuleDescriptor = this.getTaskDescriptor(taskDefinition.getPluginKey());
        return taskModuleDescriptor != null && (taskConfigurator = (TaskTestResultsSupport)Narrow.to((Object)taskModuleDescriptor.getTaskConfigurator(), TaskTestResultsSupport.class)) != null && taskConfigurator.taskProducesTestResults(taskDefinition);
    }

    public Map<String, String> getExecutableLabelTypeMap() {
        Set<String> availableExecutableTypes = this.getAvailableExecutableTypes();
        Collection capabilityCollection = this.capabilitySetManager.getSystemCapabilityKeys("builder", this.elasticAccountBean.isElasticSupportEnabled());
        HashMap<String, String> executableLabelTypeMap = new HashMap<String, String>();
        for (String capabilityKey : capabilityCollection) {
            String[] strings = capabilityKey.split("\\.", 4);
            if (strings.length != 4) continue;
            String label = strings[3];
            String type = strings[2];
            if (!availableExecutableTypes.contains(type)) continue;
            executableLabelTypeMap.putIfAbsent(label, type);
        }
        return executableLabelTypeMap;
    }

    public Set<String> getCapabilitiesWithExecutables(@NotNull Set<String> interestingExecutableTypes) {
        Set<String> availableExecutableTypes = this.getAvailableExecutableTypes();
        HashSet<String> capabilitiesWithExecutables = new HashSet<String>();
        Collection capabilityCollection = this.capabilitySetManager.getSystemCapabilityKeys("builder", this.elasticAccountBean.isElasticSupportEnabled());
        for (String capabilityKey : capabilityCollection) {
            String type;
            String[] strings = StringUtils.split((String)capabilityKey, (String)".", (int)4);
            if (strings.length != 4 || !availableExecutableTypes.contains(type = strings[2]) || !interestingExecutableTypes.contains(type)) continue;
            capabilitiesWithExecutables.add(capabilityKey);
        }
        return capabilitiesWithExecutables;
    }

    public void recalculateRequirementsForJob(Job job, boolean dockerPipelinesEnabled) {
        List taskDefinitions;
        List list = taskDefinitions = job.getPlanKey() == null ? Collections.emptyList() : job.getTaskDefinitions();
        if (taskDefinitions.isEmpty()) {
            if (dockerPipelinesEnabled) {
                job.getRequirementSet().addRequirement(this.createDockerRequirement());
            } else {
                this.removeDockerBoxRequirement(job.getRequirementSet());
            }
        } else {
            taskDefinitions.forEach(task -> this.calculateRequirementsForTaskDefinition(job.getRequirementSet(), (TaskDefinition)task, this.getJobRequirementsSupplier(job, (TaskDefinition)task), dockerPipelinesEnabled));
        }
    }

    private void removeDockerBoxRequirement(RequirementSet requirementSet) {
        requirementSet.removeRequirements(DOCKERBOX_REQUIREMENT::equals);
    }

    private Requirement createDockerRequirement() {
        return new RequirementImpl(DOCKERBOX_REQUIREMENT);
    }

    private Set<String> getAvailableExecutableTypes() {
        Stream<String> executablesFromTasks = this.pluginAccessor.getEnabledModuleDescriptorsByClass(TaskModuleDescriptor.class).stream().map(TaskModuleDescriptor::getTaskExecutables).flatMap(Collection::stream);
        return executablesFromTasks.map(TaskExecutableType::getExecutableKey).collect(Collectors.toSet());
    }

    private List<TaskModuleDescriptor> getAvailableTaskDescriptors(@NotNull Predicate<TaskModuleDescriptor> predicate) {
        return Comparators.getModuleDescriptorNameOrdering().sortedCopy(Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(TaskModuleDescriptor.class), predicate));
    }

    private static class IsTaskDescriptorOfTaskType<T extends InternalTaskType>
    implements Predicate<TaskModuleDescriptor> {
        private Class<T> requestedTaskClass;

        private IsTaskDescriptorOfTaskType(@NotNull Class<T> requestedTaskClass) {
            this.requestedTaskClass = requestedTaskClass;
        }

        public boolean apply(TaskModuleDescriptor taskModuleDescriptor) {
            Class taskClass = taskModuleDescriptor.getModuleClass();
            return taskClass != null && (this.requestedTaskClass.isAssignableFrom(taskClass) || CommonTaskType.class.isAssignableFrom(taskClass));
        }
    }
}

