/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskResult;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class TaskPredicates {
    private TaskPredicates() {
    }

    public static Predicate<TaskDefinition> isFinalisingTaskDefinition() {
        return IsFinalisingTaskDefinitionPredicate.INSTANCE;
    }

    public static Predicate<TaskDefinition> isFinalisingEqual(boolean isFinalising) {
        return new IsFinalisingEqualPredicate(isFinalising);
    }

    public static Predicate<TaskDefinition> hasTaskDefinitionEqualId(long id) {
        return td -> td.getId() == id;
    }

    public static Predicate<TaskDefinition> hasTaskDefinitionEqualId(@NotNull TaskDefinition taskDefinition) {
        return td -> td.getId() == taskDefinition.getId();
    }

    @Deprecated
    public static Predicate<TaskIdentifier> isTaskDefinitionPluginKeyEqual(@NotNull String pluginKey) {
        return BambooPluginUtils.pluginKeyEquals(pluginKey)::test;
    }

    public static Predicate<TaskDefinition> isTaskEnabled() {
        return new IsTaskDefinitionEnabled();
    }

    public static Predicate<TaskResult> isTaskResultPluginKeyEqual(@NotNull String pluginKey) {
        return Predicates.compose(BambooPluginUtils.pluginKeyEquals(pluginKey)::test, TaskResult::getTaskIdentifier);
    }

    public static Predicate<TaskModuleDescriptor> providesExecutableConfiguration() {
        return new TaskModuleDescriptorProvidesTaskExecutables();
    }

    public static Predicate<TaskDefinition> isConfigurationFieldEqual(@NotNull String key, @NotNull String value) {
        return new IsConfigurationFieldEqualPredicate(key, value);
    }

    private static class IsConfigurationFieldEqualPredicate
    implements Predicate<TaskDefinition> {
        private final String key;
        private final String value;

        private IsConfigurationFieldEqualPredicate(@NotNull String key, @NotNull String value) {
            this.key = key;
            this.value = value;
        }

        public boolean apply(@Nullable TaskDefinition input) {
            Map taskConfig = ((TaskDefinition)Preconditions.checkNotNull((Object)input)).getConfiguration();
            return taskConfig.containsKey(this.key) && ((String)taskConfig.get(this.key)).equals(this.value);
        }
    }

    private static class TaskModuleDescriptorProvidesTaskExecutables
    implements Predicate<TaskModuleDescriptor> {
        private TaskModuleDescriptorProvidesTaskExecutables() {
        }

        public boolean apply(TaskModuleDescriptor taskModuleDescriptor) {
            return !taskModuleDescriptor.getTaskExecutables().isEmpty();
        }
    }

    private static class IsTaskDefinitionEnabled
    implements Predicate<TaskDefinition> {
        private IsTaskDefinitionEnabled() {
        }

        public boolean apply(@Nullable TaskDefinition input) {
            return ((TaskDefinition)Preconditions.checkNotNull((Object)input)).isEnabled();
        }
    }

    private static class IsFinalisingEqualPredicate
    implements Predicate<TaskDefinition> {
        private final boolean isFinalising;

        private IsFinalisingEqualPredicate(boolean isFinalising) {
            this.isFinalising = isFinalising;
        }

        public boolean apply(@Nullable TaskDefinition input) {
            return this.isFinalising == ((TaskDefinition)Preconditions.checkNotNull((Object)input)).isFinalising();
        }
    }

    private static enum IsFinalisingTaskDefinitionPredicate implements Predicate<TaskDefinition>
    {
        INSTANCE;


        public boolean apply(@Nullable TaskDefinition input) {
            return ((TaskDefinition)Preconditions.checkNotNull((Object)input)).isFinalising();
        }
    }
}

