/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task.repository;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.environments.RepositoryAwareDeploymentTaskConfigurator;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryManager;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.repository.RepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.runtime.VcsExecutorWithRequirements;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyManager;
import com.opensymphony.xwork2.TextProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRepositoryAwareTaskConfigurator
extends AbstractTaskConfigurator
implements RepositoryAwareTaskConfigurator,
RepositoryAwareDeploymentTaskConfigurator {
    private static final Logger log = Logger.getLogger(AbstractRepositoryAwareTaskConfigurator.class);
    protected TextProvider textProvider;
    protected RepositoryManager repositoryManager;
    protected RepositoryDefinitionManager repositoryDefinitionManager;
    protected EnvironmentService environmentService;
    protected VcsRepositoryManager vcsRepositoryManager;

    public void handleRepositoryIdChanged(@NotNull TaskDefinition taskDefinition, @NotNull Map<Long, Long> repositoryIdChanges) {
        RepositoryTaskHelper.replaceRepositoryReferences(taskDefinition, repositoryIdChanges);
    }

    @NotNull
    public List<RepositoryDefinition> getRepositoriesUsedByTask(@NotNull TaskDefinition taskDefinition, @NotNull ImmutableJob job) {
        return RepositoryTaskHelper.safeGetRepositoriesUsedByTask(taskDefinition, job.getParent().getEffectiveRepositoryDefinitions());
    }

    @NotNull
    public List<RepositoryDefinition> getRepositoriesUsedByTask(@NotNull TaskDefinition taskDefinition, @NotNull Environment environment) {
        return RepositoryTaskHelper.safeGetRepositoriesUsedByTask(taskDefinition, this.environmentService.getRepositoryDefinitionsForEnvironment(environment));
    }

    @NotNull
    public List<PlanRepositoryDefinition> getPlanRepositoriesUsedByTask(@NotNull TaskDefinition taskDefinition, @NotNull ImmutableJob job) {
        return RepositoryTaskHelper.safeGetPlanRepositoriesUsedByTask(taskDefinition, job.getParent().getPlanRepositoryDefinitions());
    }

    @NotNull
    public List<PlanRepositoryDefinition> getPlanRepositoriesUsedByTask(@NotNull TaskDefinition taskDefinition, @NotNull InternalEnvironment environment) {
        return RepositoryTaskHelper.safeGetPlanRepositoriesUsedByTask(taskDefinition, this.environmentService.getPlanRepositoryDefinitionsForEnvironment(environment));
    }

    private Set<Requirement> calculateRequirementsForRepositoryList(List<PlanRepositoryDefinition> repositoryDefinitions) throws Exception {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        for (PlanRepositoryDefinition repositoryDefinition : repositoryDefinitions) {
            VcsWorkingCopyManager vcsWorkingCopyManager = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey()).getWorkingCopyManager();
            VcsExecutorWithRequirements executorWithRequirements = (VcsExecutorWithRequirements)Narrow.to((Object)vcsWorkingCopyManager, VcsExecutorWithRequirements.class);
            if (executorWithRequirements == null) continue;
            requirements.addAll(executorWithRequirements.getRequirements((VcsRepositoryData)repositoryDefinition));
        }
        return requirements;
    }

    @Override
    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        try {
            List<PlanRepositoryDefinition> repositoryDefinitions = this.getPlanRepositoriesUsedByTask(taskDefinition, (ImmutableJob)job);
            return this.calculateRequirementsForRepositoryList(repositoryDefinitions);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while calculating requirements for task", e);
        }
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Environment environment) {
        HashSet requirements = new HashSet();
        try {
            List<PlanRepositoryDefinition> repositoryDefinitions = this.getPlanRepositoriesUsedByTask(taskDefinition, (InternalEnvironment)environment);
            return this.calculateRequirementsForRepositoryList(repositoryDefinitions);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while calculating requirements for task", e);
        }
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setEnvironmentService(EnvironmentService environmentService) {
        this.environmentService = environmentService;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }
}

