/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task.repository;

import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionException;
import com.atlassian.bamboo.repository.RepositoryFunctions;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RepositoryTaskHelper {
    private static final Logger log = Logger.getLogger(RepositoryTaskHelper.class);
    public static final String CFG_SELECTED_REPOSITORY_ID_PREFIX = (String)BambooConstantUtils.preventInlining((Object)"selectedRepository_");
    public static final String CFG_DEFAULT_REPOSITORY = (String)BambooConstantUtils.preventInlining((Object)"defaultRepository");
    public static final String CFG_SELECTED_REPOSITORY = (String)BambooConstantUtils.preventInlining((Object)"selectedRepository");
    public static final String CFG_CHECKOUT_DIR_PREFIX = (String)BambooConstantUtils.preventInlining((Object)"checkoutDir_");
    public static final Predicate<String> isRepositorySelector = RepositoryTaskHelper::isRepositorySelector;
    public static final Ordering<String> orderingOfRepositorySelectors = new Ordering<String>(){

        private int getIndexValue(String s) {
            return Integer.parseInt(s.substring(CFG_SELECTED_REPOSITORY_ID_PREFIX.length()));
        }

        public int compare(String left, String right) {
            return this.getIndexValue(left) - this.getIndexValue(right);
        }
    };

    private RepositoryTaskHelper() {
    }

    public static final boolean isRepositorySelector(String input) {
        return input.startsWith(CFG_SELECTED_REPOSITORY_ID_PREFIX) || input.equals(CFG_SELECTED_REPOSITORY);
    }

    @Deprecated
    @NotNull
    public static List<Result<RepositoryDefinitionException, RepositoryDefinition>> getRepositoriesUsedByTask(@NotNull TaskDefinition taskDefinition, @NotNull List<RepositoryDefinition> repositoryDefinitionList) {
        return RepositoryTaskHelper.getIterableRepositoriesUsedByTask(taskDefinition, repositoryDefinitionList).collect(Collectors.toList());
    }

    @Deprecated
    @NotNull
    public static List<RepositoryDefinition> safeGetRepositoriesUsedByTask(@NotNull TaskDefinition taskDefinition, @NotNull List<RepositoryDefinition> repositoryDefinitionList) {
        return RepositoryTaskHelper.getIterableRepositoriesUsedByTask(taskDefinition, repositoryDefinitionList).map(arg_0 -> BambooFunctions.getResultOrNull().apply(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Stream<Result<RepositoryDefinitionException, RepositoryDefinition>> getIterableRepositoriesUsedByTask(@NotNull TaskDefinition taskDefinition, @NotNull List<RepositoryDefinition> repositoryDefinitionList) {
        return taskDefinition.getConfiguration().keySet().stream().filter(RepositoryTaskHelper::isRepositorySelector).map(arg_0 -> RepositoryFunctions.idSelectorToRepositoryDefinition(repositoryDefinitionList, taskDefinition).apply(arg_0));
    }

    @NotNull
    public static List<PlanRepositoryDefinition> safeGetPlanRepositoriesUsedByTask(@NotNull TaskDefinition taskDefinition, @NotNull List<PlanRepositoryDefinition> repositoryDefinitionList) {
        return taskDefinition.getConfiguration().keySet().stream().filter(RepositoryTaskHelper::isRepositorySelector).map(arg_0 -> RepositoryFunctions.idSelectorToPlanRepositoryDefinition(repositoryDefinitionList, taskDefinition).apply(arg_0)).map(arg_0 -> BambooFunctions.getResultOrNull().apply(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void replaceRepositoryReferences(@NotNull TaskDefinition taskDefinition, @NotNull Map<Long, Long> repositoryIdChanges) {
        taskDefinition.getConfiguration().keySet().stream().filter(arg_0 -> isRepositorySelector.apply(arg_0)).forEach(key -> {
            String repositoryIdString = (String)taskDefinition.getConfiguration().get(key);
            if (!CFG_DEFAULT_REPOSITORY.equals(repositoryIdString)) {
                Long repositoryId = Long.parseLong(repositoryIdString);
                if (repositoryIdChanges.keySet().contains(repositoryId)) {
                    taskDefinition.getConfiguration().put(key, Long.toString((Long)repositoryIdChanges.get(repositoryId)));
                }
            }
        });
    }

    public static RepositoryDefinition getRepositoryDefinitionByIdSelector(@NotNull CommonTaskContext commonTaskContext, @NotNull String repositoryIdSelector) throws RepositoryDefinitionException {
        return (RepositoryDefinition)((Result)RepositoryFunctions.idSelectorToRepositoryDefinition(commonTaskContext).apply((Object)repositoryIdSelector)).getResultThrowException();
    }

    public static RepositoryDefinition getRepositoryDefinitionByIdSelector(@NotNull CommonContext buildContext, @NotNull TaskDefinition taskDefinition, @NotNull String repositoryIdSelector) throws RepositoryDefinitionException {
        return (RepositoryDefinition)((Result)RepositoryFunctions.idSelectorToRepositoryDefinition(buildContext.getRepositoryDefinitionMap(), taskDefinition).apply((Object)repositoryIdSelector)).getResultThrowException();
    }

    public static PlanRepositoryDefinition getPlanRepositoryByIdSelector(@NotNull CommonTaskContext commonTaskContext, @NotNull String repositoryIdSelector) throws RepositoryDefinitionException {
        return (PlanRepositoryDefinition)((Result)RepositoryFunctions.idSelectorToPlanRepositoryDefinition(commonTaskContext).apply((Object)repositoryIdSelector)).getResultThrowException();
    }

    public static PlanRepositoryDefinition getPlanRepositoryByIdSelector(@NotNull CommonContext buildContext, @NotNull TaskDefinition taskDefinition, @NotNull String repositoryIdSelector) throws RepositoryDefinitionException {
        return (PlanRepositoryDefinition)((Result)RepositoryFunctions.idSelectorToPlanRepositoryDefinition(buildContext.getVcsRepositoryMap(), taskDefinition).apply((Object)repositoryIdSelector)).getResultThrowException();
    }
}

