/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task.runtime;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class RuntimeTaskDefinitionImpl
extends TaskDefinitionImpl
implements RuntimeTaskDefinition {
    private FinalHashMap<String, String> runtimeContext;
    private FinalHashMap<String, WhitelistedSerializable> runtimeData;
    private boolean producesTestResults;

    public RuntimeTaskDefinitionImpl(@NotNull TaskDefinition t, @Nullable Map<String, String> runtimeContext, @Nullable Map<String, WhitelistedSerializable> runtimeData, boolean producesTestResults) {
        super(t.getId(), t.getPluginKey(), t.getUserDescription(), t.isEnabled(), t.getConditions(), t.getConfiguration(), t.isFinalising(), t.getRootDirectorySelector());
        this.runtimeContext = runtimeContext != null ? new FinalHashMap(runtimeContext) : new FinalHashMap();
        this.runtimeData = runtimeData != null ? new FinalHashMap(runtimeData) : new FinalHashMap();
        this.producesTestResults = producesTestResults;
    }

    public RuntimeTaskDefinitionImpl(@NotNull TaskDefinition t, @Nullable Map<String, String> runtimeContext, boolean producesTestResults) {
        this(t, runtimeContext, null, producesTestResults);
    }

    public RuntimeTaskDefinitionImpl(@NotNull TaskDefinition t) {
        this(t, null, false);
    }

    @NotNull
    public Map<String, String> getRuntimeContext() {
        return this.runtimeContext;
    }

    @NotNull
    public Map<String, WhitelistedSerializable> getRuntimeData() {
        return this.runtimeData;
    }

    public boolean doesTaskProduceTestResults() {
        return this.producesTestResults;
    }

    public void setRuntimeContext(Map<String, String> runtimeContext) {
        this.runtimeContext = new FinalHashMap(runtimeContext);
    }

    public void setRuntimeData(Map<String, WhitelistedSerializable> runtimeData) {
        this.runtimeData = new FinalHashMap(runtimeData);
    }

    public void setProducesTestResults(boolean producesTestResults) {
        this.producesTestResults = producesTestResults;
    }
}

