/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.v2.events.ChangeDetectionRequiredEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DetectChangesAfterBuildCompletedListener {
    private static final Logger log = Logger.getLogger(DetectChangesAfterBuildCompletedListener.class);
    private EventPublisher eventPublisher;
    private CachedPlanManager cachedPlanManager;
    private TriggerTypeManager triggerTypeManager;

    @EventListener
    public void onChainCompletedEvent(ChainCompletedEvent event) {
        this.onEvent(event);
    }

    private void onEvent(ChainCompletedEvent event) {
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(event.getPlanKey(), ImmutableChain.class);
        if (chain == null) {
            log.warn((Object)("No chain found for " + event.getPlanKey()));
            return;
        }
        BuildDefinition buildDefinition = chain.getBuildDefinition();
        buildDefinition.getTriggerDefinitions().stream().filter(this::requiresDetectChanges).forEach(triggerDefinition -> this.publishDetectChangesEvent(chain, (TriggerDefinition)triggerDefinition));
    }

    private boolean requiresDetectChanges(@NotNull TriggerDefinition triggerDefinition) {
        if (!triggerDefinition.isEnabled()) {
            return false;
        }
        TriggerModuleDescriptor triggerModuleDescriptor = this.triggerTypeManager.getTriggerDescriptor(triggerDefinition.getPluginKey());
        return triggerModuleDescriptor != null && triggerModuleDescriptor.requiresChangeDetectionOnCompletion();
    }

    private void publishDetectChangesEvent(ImmutableChain chain, TriggerDefinition triggerDefinition) {
        this.eventPublisher.publish((Object)new ChangeDetectionRequiredEvent(this, chain.getPlanKey(), triggerDefinition, false, CacheAwareness.CHANGE_DETECTION));
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setTriggerTypeManager(TriggerTypeManager triggerTypeManager) {
        this.triggerTypeManager = triggerTypeManager;
    }
}

