/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger;

import com.atlassian.bamboo.trigger.TriggerActivator;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TriggerActivatorHelper {
    private TriggerActivatorHelper() {
    }

    private static void doIt(@NotNull TriggerTypeManager triggerTypeManager, @NotNull Triggerable triggerable, @NotNull Logger log, @NotNull Op op, @Nullable Date lastShutdownTime) {
        String opString = op == Op.DEACTIVATE ? "deactivate" : "activate";
        for (TriggerDefinition triggerDefinition : triggerable.getTriggerDefinitions()) {
            try {
                TriggerActivator triggerActivator = triggerTypeManager.getTriggerActivator(triggerDefinition.getPluginKey());
                if (triggerActivator != null) {
                    if (!triggerDefinition.isEnabled() && op != Op.DEACTIVATE) continue;
                    switch (op) {
                        case INIT: {
                            triggerActivator.initAndActivate(triggerable, triggerDefinition, lastShutdownTime);
                            break;
                        }
                        case ACTIVATE: {
                            triggerActivator.activate(triggerable, triggerDefinition);
                            break;
                        }
                        case DEACTIVATE: {
                            triggerActivator.deactivate(triggerable, triggerDefinition);
                        }
                    }
                    continue;
                }
                log.warn((Object)("could not " + opString + " trigger " + triggerDefinition.getName() + " " + triggerDefinition.getUserDescription()));
            }
            catch (Exception e) {
                log.warn((Object)("could not " + opString + " trigger " + triggerDefinition.getName() + " " + triggerDefinition.getUserDescription()), (Throwable)e);
            }
        }
    }

    public static void initAndActivateTriggers(@NotNull TriggerTypeManager triggerTypeManager, @NotNull Triggerable triggerable, @NotNull Logger log, @Nullable Date lastShutdownTime) {
        TriggerActivatorHelper.doIt(triggerTypeManager, triggerable, log, Op.INIT, lastShutdownTime);
    }

    public static void activateTriggers(@NotNull TriggerTypeManager triggerTypeManager, @NotNull Triggerable triggerable, @NotNull Logger log) {
        TriggerActivatorHelper.doIt(triggerTypeManager, triggerable, log, Op.ACTIVATE, null);
    }

    public static void deactivateTriggers(@NotNull TriggerTypeManager triggerTypeManager, @NotNull Triggerable triggerable, @NotNull Logger log) {
        TriggerActivatorHelper.doIt(triggerTypeManager, triggerable, log, Op.DEACTIVATE, null);
    }

    private static enum Op {
        INIT,
        ACTIVATE,
        DEACTIVATE;

    }
}

