/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.persister.TriggerAuditLogHelper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TriggerConfigurationServiceImpl
implements TriggerConfigurationService {
    private static final Logger log = Logger.getLogger(TriggerConfigurationServiceImpl.class);
    private final BuildDefinitionManager buildDefinitionManager;
    private final TextProvider textProvider;
    private final PlanManager planManager;
    private final AuditLogService auditLogService;
    private final ScopedExclusionService scopedExclusionService;

    public TriggerConfigurationServiceImpl(@NotNull BuildDefinitionManager buildDefinitionManager, @NotNull TextProvider textProvider, @NotNull PlanManager planManager, @NotNull AuditLogService auditLogService, @NotNull ScopedExclusionService scopedExclusionService) {
        this.buildDefinitionManager = buildDefinitionManager;
        this.textProvider = textProvider;
        this.planManager = planManager;
        this.auditLogService = auditLogService;
        this.scopedExclusionService = scopedExclusionService;
    }

    public TriggerDefinition createTrigger(@NotNull PlanKey planKey, @NotNull TriggerModuleDescriptor triggerDescriptor, @NotNull String userDescription, boolean isEnabled, @Nullable Set<Long> triggeringRepositories, @NotNull Map<String, String> configuration, @NotNull Map<String, String> triggerConditionsConfiguration) throws IllegalArgumentException {
        Supplier<TriggerDefinition> createBuildStrategyFunctor = this.createTriggerFunctor(planKey, triggerDescriptor, userDescription, isEnabled, triggeringRepositories, configuration, triggerConditionsConfiguration);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(createBuildStrategyFunctor);
        return ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, planKey, functor);
    }

    private Supplier<TriggerDefinition> createTriggerFunctor(final @NotNull PlanKey planKey, final @NotNull TriggerModuleDescriptor triggerDescriptor, final @NotNull String userDescription, final boolean isEnabled, final @Nullable Set<Long> triggeringRepositories, final @NotNull Map<String, String> configuration, final @NotNull Map<String, String> triggerConditionsConfiguration) {
        return new Supplier<TriggerDefinition>(){

            @Override
            public TriggerDefinition get() {
                Chain chain = (Chain)TriggerConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Chain.class);
                if (chain == null) {
                    throw new IllegalArgumentException("Could not create a new Trigger, no Chain was found with the key: " + planKey);
                }
                BuildDefinition buildDefinition = TriggerConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(chain.getPlanKey());
                ArrayList triggerDefinitions = Lists.newArrayList((Iterable)buildDefinition.getTriggerDefinitions());
                TriggerDefinition newTriggerDefinition = new TriggerDefinitionImpl.Builder().fromDescriptor(triggerDescriptor).id(TriggerConfigurationUtils.getUniqueId(triggerDefinitions)).userDescription(userDescription).triggeringRepositories(triggeringRepositories).configuration(configuration).triggerConditionsConfiguration(triggerConditionsConfiguration).enabled(isEnabled).build();
                triggerDefinitions.add(newTriggerDefinition);
                buildDefinition.setTriggerDefinitions((List)triggerDefinitions);
                TriggerConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)chain, buildDefinition);
                TriggerAuditLogHelper.logTriggerCreation(TriggerConfigurationServiceImpl.this.auditLogService, (Key)planKey, newTriggerDefinition, AuditLogEntityType.PLAN);
                return newTriggerDefinition;
            }
        };
    }

    public void deleteTrigger(@NotNull PlanKey planKey, long triggerId) throws IllegalArgumentException, IllegalStateException {
        Runnable deleteBuildStrategyFunctor = this.deleteTriggerFunctor(planKey, triggerId);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(deleteBuildStrategyFunctor);
        ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, planKey, functor);
    }

    private Runnable deleteTriggerFunctor(final PlanKey planKey, final long triggerId) {
        return new Runnable(){

            @Override
            public void run() {
                Chain chain = (Chain)TriggerConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Chain.class);
                if (chain == null) {
                    throw new IllegalArgumentException("Could not delete a Trigger, no Chain was found with the key: " + planKey);
                }
                BuildDefinition buildDefinition = TriggerConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(chain.getPlanKey());
                ArrayList triggers = Lists.newArrayList((Iterable)buildDefinition.getTriggerDefinitions());
                TriggerDefinition triggerDefinition = TriggerConfigurationUtils.getTriggerDefinitionById(triggers, triggerId);
                if (triggerDefinition == null) {
                    throw new IllegalArgumentException(TriggerConfigurationServiceImpl.this.textProvider.getText("chain.trigger.edit.error.incorrectId", (List)ImmutableList.of((Object)triggerId)));
                }
                Iterables.removeIf((Iterable)triggers, BambooPredicates.hasBambooObjectEqualId(triggerId));
                buildDefinition.setTriggerDefinitions((List)triggers);
                TriggerConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)chain, buildDefinition);
                TriggerAuditLogHelper.logTriggerRemoval(TriggerConfigurationServiceImpl.this.auditLogService, (Key)planKey, triggerDefinition, AuditLogEntityType.PLAN);
            }
        };
    }

    public TriggerDefinition editTrigger(@NotNull PlanKey planKey, long triggerId, @Nullable String userDescription, boolean isEnabled, @Nullable Set<Long> triggeringRepositories, @NotNull Map<String, String> triggerConfigurationMap, @NotNull Map<String, String> triggerConditionsConfiguration) throws IllegalArgumentException {
        Supplier<TriggerDefinition> editBuildStrategyFunctor = this.editTriggerFunctor(planKey, triggerId, userDescription, isEnabled, triggeringRepositories, triggerConfigurationMap, triggerConditionsConfiguration);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(editBuildStrategyFunctor);
        return ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, planKey, functor);
    }

    private Supplier<TriggerDefinition> editTriggerFunctor(final @NotNull PlanKey planKey, final long triggerId, final @NotNull String userDescription, final boolean isEnabled, final @Nullable Set<Long> triggeringRepositories, final @NotNull Map<String, String> triggerConfigurationMap, final @NotNull Map<String, String> triggerConditionsConfiguration) {
        return new Supplier<TriggerDefinition>(){

            @Override
            public TriggerDefinition get() {
                Chain chain = (Chain)TriggerConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Chain.class);
                if (chain == null) {
                    throw new IllegalArgumentException("Could not create a new Trigger, no Chain was found with the key: " + planKey);
                }
                BuildDefinition buildDefinition = TriggerConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(chain.getPlanKey());
                List triggers = buildDefinition.getTriggerDefinitions();
                TriggerDefinition triggerDefinition = TriggerConfigurationUtils.getTriggerDefinitionById(triggers, triggerId);
                if (triggerDefinition == null) {
                    throw new IllegalArgumentException(TriggerConfigurationServiceImpl.this.textProvider.getText("chain.trigger.edit.error.incorrectId", (List)ImmutableList.of((Object)triggerId)));
                }
                TriggerDefinition newTriggerDefinition = new TriggerDefinitionImpl.Builder().fromExisting(triggerDefinition).userDescription(userDescription).triggeringRepositories(triggeringRepositories).configuration(triggerConfigurationMap).triggerConditionsConfiguration(triggerConditionsConfiguration).enabled(isEnabled).build();
                ArrayList<TriggerDefinition> newTriggerList = new ArrayList<TriggerDefinition>();
                for (TriggerDefinition triggerDefinition1 : triggers) {
                    if (triggerDefinition1.getId() == triggerId) {
                        newTriggerList.add(newTriggerDefinition);
                        continue;
                    }
                    newTriggerList.add(triggerDefinition1);
                }
                buildDefinition.setTriggerDefinitions(newTriggerList);
                TriggerConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)chain, buildDefinition);
                TriggerAuditLogHelper.logTriggerChanges(TriggerConfigurationServiceImpl.this.auditLogService, (Key)planKey, triggerDefinition, newTriggerDefinition, AuditLogEntityType.PLAN);
                return newTriggerDefinition;
            }
        };
    }

    public void createTriggerList(PlanKey planKey, @NotNull List<TriggerDefinition> triggerDefinitions) {
        Runnable createTriggerListFunctor = this.createTriggerListFunctor(planKey, triggerDefinitions);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(createTriggerListFunctor);
        ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, planKey, functor);
    }

    private Runnable createTriggerListFunctor(final PlanKey planKey, final @NotNull List<TriggerDefinition> triggerDefinitions) {
        return new Runnable(){

            @Override
            public void run() {
                Chain chain = (Chain)TriggerConfigurationServiceImpl.this.planManager.getPlanByKeyIfOfType(planKey, Chain.class);
                if (chain == null) {
                    throw new IllegalArgumentException("Could not create trigger list, no Chain was found with the key: " + planKey);
                }
                BuildDefinition buildDefinition = TriggerConfigurationServiceImpl.this.buildDefinitionManager.getBuildDefinition(chain.getPlanKey());
                List removedTriggers = buildDefinition.getTriggerDefinitions();
                buildDefinition.setTriggerDefinitions(triggerDefinitions);
                TriggerConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)chain, buildDefinition);
                for (TriggerDefinition triggerDefinition : triggerDefinitions) {
                    TriggerAuditLogHelper.logTriggerCreation(TriggerConfigurationServiceImpl.this.auditLogService, (Key)planKey, triggerDefinition, AuditLogEntityType.PLAN);
                }
                for (TriggerDefinition triggerDefinition : removedTriggers) {
                    TriggerAuditLogHelper.logTriggerRemoval(TriggerConfigurationServiceImpl.this.auditLogService, (Key)planKey, triggerDefinition, AuditLogEntityType.PLAN);
                }
            }
        };
    }

    public void addTriggeringRepository(@NotNull Chain chain, long repositoryId) {
        this.updateRepositoryIdsInTriggers(chain, (Map<Long, Long>)ImmutableMap.of((Object)-1L, (Object)repositoryId));
    }

    public void updateRepositoryIdsInTriggers(@NotNull Chain chain, Map<Long, Long> repositoryIdsChanges) {
        this.updateRepositoryIdsInTriggers(chain, repositoryIdsChanges, true);
    }

    public void updateRepositoryIdsInTriggers(@NotNull Chain chain, Map<Long, Long> repositoryIdsChanges, boolean reactivateTriggers) {
        Runnable updateRepositoryIdsFunctor = this.updateRepositoryIdsFunctor(chain, repositoryIdsChanges, reactivateTriggers);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(updateRepositoryIdsFunctor);
        ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, chain.getPlanKey(), functor);
    }

    private Runnable updateRepositoryIdsFunctor(final Chain chain, final Map<Long, Long> repositoryIdsChanges, final boolean reactivateTriggers) {
        return new Runnable(){

            @Override
            public void run() {
                BuildDefinition buildDefinition = TriggerConfigurationServiceImpl.this.buildDefinitionManager.getUnmergedBuildDefinition(chain.getPlanKey());
                List triggers = buildDefinition.getTriggerDefinitions();
                if (!CollectionUtils.isEmpty((Collection)triggers)) {
                    TriggerConfigurationUtils.updateRepositoryIdsInTriggers(triggers, repositoryIdsChanges);
                    TriggerConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)chain, buildDefinition, reactivateTriggers);
                }
            }
        };
    }

    public void removeRepositoryIdsFromTriggers(@NotNull Chain chain, Set<Long> removedRepositoriesIds) {
        Runnable removeRepositoryIdsFunctor = this.removeRepositoryIdsFromTriggersFunctor(chain, removedRepositoriesIds);
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(removeRepositoryIdsFunctor);
        ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, chain.getPlanKey(), functor);
    }

    private Runnable removeRepositoryIdsFromTriggersFunctor(final @NotNull Chain chain, final Set<Long> removeRepositoriesIds) {
        return new Runnable(){

            @Override
            public void run() {
                BuildDefinition buildDefinition = TriggerConfigurationServiceImpl.this.buildDefinitionManager.getUnmergedBuildDefinition(chain.getPlanKey());
                List triggers = buildDefinition.getTriggerDefinitions();
                if (!CollectionUtils.isEmpty((Collection)triggers)) {
                    TriggerConfigurationUtils.removeRepositoryIdsFromTriggers(triggers, removeRepositoriesIds);
                    TriggerConfigurationServiceImpl.this.buildDefinitionManager.savePlanAndDefinition((Plan)chain, buildDefinition);
                }
            }
        };
    }
}

