/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.build.strategy.BuildStrategyManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.CollectionUtils;

@Internal
public class TriggerConfigurationUtils {
    private static final Logger log = Logger.getLogger(TriggerConfigurationUtils.class);
    public static final String TRIGGER_CONFIG_ROOT = "triggers";
    public static final String TRIGGER_PREFIX = "triggers.";
    public static final String TRIGGERS_DEFINED = "triggers.defined";
    public static final String TRIGGERING_REPOSITORIES = "triggeringRepositories";
    private static final String ID = "id";
    public static final String NAME = "name";
    public static final String PLUGIN_KEY = "pluginKey";
    public static final String USER_DESCRIPTION = "userDescription";
    public static final String IS_ENABLED = "isEnabled";
    public static final String CONFIG = "config";
    public static final String ITEM = "item";
    public static final String CONDITIONS = "conditions";
    public static final String TRIGGER_DEFINITION = "triggerDefinition";
    public static final String TRIGGER_DEF_PREFIX = "triggerDefinition.";

    private TriggerConfigurationUtils() {
    }

    public static void removeTriggersFromConfig(HierarchicalConfiguration config) {
        config.clearTree(TRIGGER_CONFIG_ROOT);
    }

    public static void addTriggerDefinitionsToConfig(@Nullable Iterable<TriggerDefinition> triggerDefinitions, @NotNull HierarchicalConfiguration config) {
        TriggerConfigurationUtils.removeTriggersFromConfig(config);
        if (triggerDefinitions == null) {
            return;
        }
        config.addProperty(TRIGGERS_DEFINED, (Object)true);
        for (TriggerDefinition triggerDefinition : triggerDefinitions) {
            config.addProperty("triggers.triggerDefinition(-1).id", (Object)triggerDefinition.getId());
            config.addProperty("triggers.triggerDefinition.name", (Object)triggerDefinition.getName());
            config.addProperty("triggers.triggerDefinition.userDescription", (Object)triggerDefinition.getUserDescription());
            config.addProperty("triggers.triggerDefinition.isEnabled", (Object)triggerDefinition.isEnabled());
            config.addProperty("triggers.triggerDefinition.pluginKey", (Object)triggerDefinition.getPluginKey());
            if (triggerDefinition.getTriggeringRepositories() != null) {
                config.addProperty("triggers.triggerDefinition.triggeringRepositories", (Object)TriggerConfigurationUtils.triggeringRepositoriesToString(triggerDefinition.getTriggeringRepositories()));
            }
            ConfigUtils.addMapToConfiguration((String)"triggers.triggerDefinition.config", (String)ITEM, (Map)triggerDefinition.getConfiguration(), (HierarchicalConfiguration)config);
            ConfigUtils.addMapToConfiguration((String)"triggers.triggerDefinition.conditions", (String)ITEM, (Map)triggerDefinition.getTriggerConditionsConfiguration(), (HierarchicalConfiguration)config);
        }
    }

    @Nullable
    public static ImmutableList<TriggerDefinition> getTriggerDefinitionsFromConfig(HierarchicalConfiguration fromConfig) {
        if (!fromConfig.getBoolean(TRIGGERS_DEFINED, false)) {
            return null;
        }
        ArrayList<TriggerDefinition> triggers = new ArrayList<TriggerDefinition>();
        List triggerConfigs = fromConfig.configurationsAt("triggers.triggerDefinition");
        if (triggerConfigs != null) {
            for (Object taskSubNode : triggerConfigs) {
                SubnodeConfiguration trigger = (SubnodeConfiguration)taskSubNode;
                long triggerId = trigger.getLong(ID);
                String name = trigger.getString(NAME);
                String pluginKey = trigger.getString(PLUGIN_KEY);
                String userDescription = trigger.getString(USER_DESCRIPTION);
                boolean isEnabled = trigger.getBoolean(IS_ENABLED, true);
                Map taskConfigMap = ConfigUtils.getMapFromConfiguration((String)CONFIG, (String)ITEM, (HierarchicalConfiguration)trigger);
                Set<Long> triggeringRepositories = null;
                if (trigger.containsKey(TRIGGERING_REPOSITORIES)) {
                    triggeringRepositories = TriggerConfigurationUtils.extractTriggeringRepositoriesFromCfgString(trigger.getString(TRIGGERING_REPOSITORIES));
                }
                Map triggerConditionsConfigMap = ConfigUtils.getMapFromConfiguration((String)CONDITIONS, (String)ITEM, (HierarchicalConfiguration)trigger);
                triggers.add(new TriggerDefinitionImpl.Builder().id(triggerId).name(name).pluginKey(pluginKey).userDescription(userDescription).triggeringRepositories(triggeringRepositories).configuration(BambooInterners.intern((Map)taskConfigMap)).triggerConditionsConfiguration(BambooInterners.intern((Map)triggerConditionsConfigMap)).enabled(isEnabled).build());
            }
        }
        return ImmutableList.copyOf(triggers);
    }

    @NotNull
    public static Set<Long> extractTriggeringRepositoriesFromCfgString(@NotNull String triggeringRepositoriesString) {
        HashSet<Long> triggeringRepositories = new HashSet<Long>();
        Iterables.addAll(triggeringRepositories, (Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Splitter.on((String)",").split((CharSequence)triggeringRepositoriesString), (Function)new Function<String, Long>(){

            public Long apply(String input) {
                return StringUtils.isEmpty((CharSequence)input) ? null : Long.valueOf(Long.parseLong(input));
            }
        }), Objects::nonNull));
        return triggeringRepositories;
    }

    @NotNull
    public static String triggeringRepositoriesToString(@NotNull Set<Long> triggeringRepositories) {
        return Joiner.on((String)",").join(triggeringRepositories);
    }

    @Nullable
    public static TriggerDefinition getTriggerDefinitionById(@NotNull Iterable<TriggerDefinition> triggers, long id) {
        return (TriggerDefinition)Iterables.find(triggers, BambooPredicates.hasBambooObjectEqualId(id), null);
    }

    public static long getUniqueId(@NotNull List<TriggerDefinition> triggers) {
        long max = 0L;
        for (TriggerDefinition definition : triggers) {
            max = Math.max(max, definition.getId());
        }
        return max + 1L;
    }

    @NotNull
    public static ImmutableList<TriggerDefinition> getTriggerDefinitionsFromConfigNotNull(HierarchicalConfiguration buildConfiguration) {
        return (ImmutableList)MoreObjects.firstNonNull(TriggerConfigurationUtils.getTriggerDefinitionsFromConfig(buildConfiguration), (Object)ImmutableList.of());
    }

    public static void updateRepositoryIdsInTriggers(List<TriggerDefinition> triggers, Map<Long, Long> repositoryIdsChanges) {
        ReplaceLongFunction replaceLongFunction = new ReplaceLongFunction(repositoryIdsChanges);
        if (!CollectionUtils.isEmpty(triggers)) {
            for (TriggerDefinition triggerDefinition : triggers) {
                if (triggerDefinition.getTriggeringRepositories() == null) continue;
                HashSet triggeringRepositories = Sets.newHashSet((Iterable)Iterables.transform((Iterable)triggerDefinition.getTriggeringRepositories(), (Function)replaceLongFunction));
                if (repositoryIdsChanges.containsKey(-1L)) {
                    triggeringRepositories.add(repositoryIdsChanges.get(-1L));
                }
                triggerDefinition.getTriggeringRepositories().clear();
                triggerDefinition.getTriggeringRepositories().addAll(triggeringRepositories);
            }
        }
    }

    public static void removeRepositoryIdsFromTriggers(List<TriggerDefinition> triggers, Set<Long> removedRepositoryIds) {
        for (TriggerDefinition triggerDefinition : triggers) {
            if (triggerDefinition.getTriggeringRepositories() == null) continue;
            triggerDefinition.getTriggeringRepositories().removeAll(removedRepositoryIds);
        }
    }

    public static void triggerConditionsToConfiguration(HierarchicalConfiguration buildConfiguration, TriggerDefinition triggerDefinition) {
        ConfigUtils.copyMapToConfig((Map)triggerDefinition.getTriggerConditionsConfiguration(), (Configuration)buildConfiguration);
    }

    public static Map<String, String> extractTriggerConditionConfiguration(HierarchicalConfiguration configuration) {
        HashMap<String, String> triggerConditionsConfiguration = new HashMap<String, String>();
        for (BuildTriggerCondition condition : ((BuildStrategyManager)ComponentAccessor.BUILD_STRATEGY_MANAGER.get()).getBuildTriggerConditions()) {
            triggerConditionsConfiguration.putAll(condition.getConfigurationMap(configuration));
        }
        return triggerConditionsConfiguration;
    }

    private static class ReplaceLongFunction
    implements Function<Long, Long> {
        private final Map<Long, Long> repositoryIdChanges;

        private ReplaceLongFunction(Map<Long, Long> repositoryIdChanges) {
            this.repositoryIdChanges = repositoryIdChanges;
        }

        public Long apply(Long input) {
            return this.repositoryIdChanges.getOrDefault(input, input);
        }
    }
}

