/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger;

import com.atlassian.bamboo.build.strategy.AfterSuccessfulPlanTrigger;
import com.atlassian.bamboo.build.strategy.BuildStrategy;
import com.atlassian.bamboo.build.strategy.CronTriggerBuildStrategy;
import com.atlassian.bamboo.build.strategy.ManualBuildStrategy;
import com.atlassian.bamboo.build.strategy.PollingBuildStrategy;
import com.atlassian.bamboo.build.strategy.RepositoryAwareBuildStrategy;
import com.atlassian.bamboo.build.strategy.SingleDailyBuildStrategy;
import com.atlassian.bamboo.build.strategy.StashBuildStrategy;
import com.atlassian.bamboo.build.strategy.TriggeredBuildStrategy;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TriggerDefinition2BuildStrategyConverter {
    private static final Logger log = Logger.getLogger(TriggerDefinition2BuildStrategyConverter.class);
    private static final ImmutableMap<String, Class<? extends BuildStrategy>> pluginKey2BuildStrategy = ImmutableMap.builder().put((Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:afterSuccessfulPlan", AfterSuccessfulPlanTrigger.class).put((Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:schedule", CronTriggerBuildStrategy.class).put((Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll", PollingBuildStrategy.class).put((Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:daily", SingleDailyBuildStrategy.class).put((Object)"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:stashTrigger", StashBuildStrategy.class).put((Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:remote", TriggeredBuildStrategy.class).build();
    private static final ImmutableMap<Class<? extends BuildStrategy>, String> buildStrategy2PluginName = ImmutableMap.builder().put(AfterSuccessfulPlanTrigger.class, (Object)"After successful build plan").put(CronTriggerBuildStrategy.class, (Object)"Scheduled").put(PollingBuildStrategy.class, (Object)"Repository polling").put(SingleDailyBuildStrategy.class, (Object)"Single daily build").put(StashBuildStrategy.class, (Object)"Bitbucket Server repository triggered").put(TriggeredBuildStrategy.class, (Object)"Remote trigger").build();
    private static final ImmutableMap<Class<? extends BuildStrategy>, String> buildStrategy2PluginKey = ImmutableMap.builder().put(AfterSuccessfulPlanTrigger.class, (Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:afterSuccessfulPlan").put(CronTriggerBuildStrategy.class, (Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:schedule").put(PollingBuildStrategy.class, (Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:poll").put(SingleDailyBuildStrategy.class, (Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:daily").put(StashBuildStrategy.class, (Object)"com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:stashTrigger").put(TriggeredBuildStrategy.class, (Object)"com.atlassian.bamboo.triggers.atlassian-bamboo-triggers:remote").build();
    private static final ImmutableMap<Class<? extends BuildStrategy>, String> buildStrategyConfigFilters = ImmutableMap.builder().put(AfterSuccessfulPlanTrigger.class, (Object)"deployment.trigger.afterSuccessfulPlan").put(PollingBuildStrategy.class, (Object)"repository.change.poll").put(SingleDailyBuildStrategy.class, (Object)"repository.change.daily").put(StashBuildStrategy.class, (Object)"#$%$#^$%nothingtodohere123353465465677").put(TriggeredBuildStrategy.class, (Object)"repository.change.trigger").build();

    private TriggerDefinition2BuildStrategyConverter() {
    }

    @Nullable
    public static BuildStrategy triggerDefinition2BuildStrategy(@NotNull TriggerDefinition triggerDefinition) {
        try {
            Class<? extends BuildStrategy> clazz = TriggerDefinition2BuildStrategyConverter.getBuildStrategyClass(triggerDefinition);
            if (clazz != null) {
                BuildStrategy buildStrategy = clazz.newInstance();
                XMLConfiguration hc = ConfigUtils.newConfiguration();
                ConfigUtils.copyMapToConfig((Map)triggerDefinition.getConfiguration(), (Configuration)hc);
                ConfigUtils.copyMapToConfig((Map)triggerDefinition.getTriggerConditionsConfiguration(), (Configuration)hc);
                RepositoryAwareBuildStrategy rabs = (RepositoryAwareBuildStrategy)Narrow.downTo((Object)buildStrategy, RepositoryAwareBuildStrategy.class);
                if (rabs != null) {
                    rabs.setTriggeringRepositories(triggerDefinition.getTriggeringRepositories());
                }
                buildStrategy.populateFromConfig((HierarchicalConfiguration)hc);
                buildStrategy.setUserDescription(triggerDefinition.getUserDescription());
                buildStrategy.setId(triggerDefinition.getId());
                return buildStrategy;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static Class<? extends BuildStrategy> getBuildStrategyClass(@NotNull TriggerDefinition triggerDefinition) {
        return (Class)pluginKey2BuildStrategy.get((Object)triggerDefinition.getPluginKey());
    }

    @Nullable
    public static String getPluginKeyForStrategy(@NotNull BuildStrategy buildStrategy) {
        for (Class buildStrategyClass : buildStrategy2PluginKey.keySet()) {
            if (!buildStrategyClass.isAssignableFrom(buildStrategy.getClass())) continue;
            return (String)buildStrategy2PluginKey.get((Object)buildStrategyClass);
        }
        return null;
    }

    @Nullable
    private static String getNameForStrategy(@NotNull BuildStrategy buildStrategy) {
        for (Class buildStrategyClass : buildStrategy2PluginName.keySet()) {
            if (!buildStrategyClass.isAssignableFrom(buildStrategy.getClass())) continue;
            return (String)buildStrategy2PluginName.get((Object)buildStrategyClass);
        }
        return null;
    }

    @Nullable
    public static Map<String, String> extractTriggerConfigurationFromBuildStrategy(BuildStrategy buildStrategy) {
        if (!(buildStrategy instanceof CronTriggerBuildStrategy)) {
            return ConfigUtils.asMap((Configuration)buildStrategy.toConfiguration(), (String)((String)buildStrategyConfigFilters.get(buildStrategy.getClass())));
        }
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        HierarchicalConfiguration configuration = buildStrategy.toConfiguration();
        cfgMap.putAll(ConfigUtils.asMap((Configuration)configuration, (String)"repository.change.schedule"));
        cfgMap.putAll(ConfigUtils.asMap((Configuration)configuration, (String)"deployment.trigger.schedule"));
        return cfgMap;
    }

    @Nullable
    public static TriggerDefinition buildStrategy2TriggerDefinition(BuildStrategy buildStrategy) {
        if (buildStrategy instanceof ManualBuildStrategy) {
            return null;
        }
        TriggerDefinitionImpl.Builder triggerBuilder = new TriggerDefinitionImpl.Builder().id(buildStrategy.getId()).name(TriggerDefinition2BuildStrategyConverter.getNameForStrategy(buildStrategy)).userDescription(buildStrategy.getUserDescription()).triggerConditionsConfiguration(buildStrategy.getTriggerConditionsConfiguration()).pluginKey(TriggerDefinition2BuildStrategyConverter.getPluginKeyForStrategy(buildStrategy)).configuration(TriggerDefinition2BuildStrategyConverter.extractTriggerConfigurationFromBuildStrategy(buildStrategy)).enabled(true);
        RepositoryAwareBuildStrategy rabs = (RepositoryAwareBuildStrategy)Narrow.downTo((Object)buildStrategy, RepositoryAwareBuildStrategy.class);
        if (rabs != null) {
            triggerBuilder.triggeringRepositories(rabs.getTriggeringRepositories());
        }
        return triggerBuilder.build();
    }
}

