/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.collections.message.FinalHashSet;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.utils.BambooInterners;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TriggerDefinitionImpl
implements TriggerDefinition {
    private final long id;
    private final boolean enabled;
    private final String name;
    private final String pluginKey;
    private final String userDescription;
    private final FinalHashMap<String, String> configuration;
    private final FinalHashSet<Long> triggeringRepositories;
    private final FinalHashMap<String, String> triggerConditionsConfiguration;

    private TriggerDefinitionImpl(long triggerId, @NotNull String name, @NotNull String pluginKey, @NotNull String userDescription, @NotNull Set<Long> triggeringRepositories, @NotNull Map<String, String> configuration, @NotNull Map<String, String> triggerConditionsConfiguration, boolean enabled) {
        this.id = triggerId;
        this.pluginKey = BambooInterners.moduleKey((String)pluginKey);
        this.name = BambooInterners.intern((String)name);
        this.userDescription = BambooInterners.intern((String)userDescription);
        this.configuration = new FinalHashMap(configuration);
        this.triggeringRepositories = new FinalHashSet(triggeringRepositories);
        this.triggerConditionsConfiguration = new FinalHashMap(triggerConditionsConfiguration);
        this.enabled = enabled;
    }

    @NotNull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public String getUserDescription() {
        return this.userDescription;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Set<Long> getTriggeringRepositories() {
        return this.triggeringRepositories;
    }

    @NotNull
    public Map<String, String> getTriggerConditionsConfiguration() {
        return this.triggerConditionsConfiguration;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private long id = -1L;
        private String name;
        private String pluginKey;
        private String userDescription;
        private Map<String, String> configuration;
        private Set<Long> triggeringRepositories;
        private Map<String, String> triggerConditionsConfiguration;
        private boolean enabled = true;

        public Builder fromDescriptor(@NotNull TriggerModuleDescriptor moduleDescriptor) {
            this.name = moduleDescriptor.getName();
            this.pluginKey = moduleDescriptor.getCompleteKey();
            return this;
        }

        public Builder fromExisting(@NotNull TriggerDefinition triggerDefinition) {
            this.id = triggerDefinition.getId();
            this.name = triggerDefinition.getName();
            this.pluginKey = triggerDefinition.getPluginKey();
            this.userDescription = triggerDefinition.getUserDescription();
            this.configuration = triggerDefinition.getConfiguration();
            this.triggeringRepositories = triggerDefinition.getTriggeringRepositories();
            this.triggerConditionsConfiguration = triggerDefinition.getTriggerConditionsConfiguration();
            this.enabled = triggerDefinition.isEnabled();
            return this;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(@NotNull String name) {
            this.name = name;
            return this;
        }

        public Builder pluginKey(@NotNull String pluginKey) {
            this.pluginKey = pluginKey;
            return this;
        }

        public Builder userDescription(@NotNull String userDescription) {
            this.userDescription = userDescription;
            return this;
        }

        public Builder triggeringRepositories(@Nullable Set<Long> triggeringRepositories) {
            this.triggeringRepositories = triggeringRepositories;
            return this;
        }

        public Builder configuration(@NotNull Map<String, String> configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder triggerConditionsConfiguration(@Nullable Map<String, String> triggerConditionsConfiguration) {
            this.triggerConditionsConfiguration = triggerConditionsConfiguration;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TriggerDefinition build() {
            if (this.id < 0L) {
                throw new IllegalStateException("id must be set");
            }
            if (StringUtils.isEmpty((CharSequence)this.pluginKey)) {
                throw new IllegalStateException("pluginKey must be set");
            }
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                throw new IllegalStateException("name must be set");
            }
            if (this.configuration == null) {
                throw new IllegalStateException("undefined configuration");
            }
            if (this.triggerConditionsConfiguration == null) {
                this.triggerConditionsConfiguration = Collections.emptyMap();
            }
            if (this.triggeringRepositories == null) {
                this.triggeringRepositories = Collections.emptySet();
            }
            return new TriggerDefinitionImpl(this.id, this.name, this.pluginKey, this.userDescription, this.triggeringRepositories, this.configuration, this.triggerConditionsConfiguration, this.enabled);
        }
    }
}

