/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.bandana.BambooBandanaContextImpl;
import com.atlassian.bamboo.utils.Comparators;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;

public class UpgradeUtilityBean {
    private static final String LOWEST_VERSION_APPLICABLE_FOR_UPGRADE = "5.12";
    private static final String BAMBOO_5_12_BUILD_NUMBER = "51200";
    private static final String DB_VERSION_BANDANA_KEY = "bamboo.db.version";
    private static final BambooBandanaContext DB_VERSION_BANDANA_CONTEXT = new BambooBandanaContextImpl(null, UpgradeUtilityBean.class.getCanonicalName());
    private final Comparator<String> buildNumberComparator = Comparators.getApplicationBuildNumberComparator();

    public boolean isBuildNumberApplicableForUpgrade(String buildNumber) {
        return StringUtils.isNumeric((CharSequence)buildNumber) && Comparators.isGreaterOrEqual(buildNumber, BAMBOO_5_12_BUILD_NUMBER, this.buildNumberComparator);
    }

    public String getLowestBambooVersionApplicableForUpgrade() {
        return LOWEST_VERSION_APPLICABLE_FOR_UPGRADE;
    }

    public BambooBandanaContext getBandanaContextForDbVersion() {
        return DB_VERSION_BANDANA_CONTEXT;
    }

    public String getBandanaKeyForDbVersion() {
        return DB_VERSION_BANDANA_KEY;
    }
}

