/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user;

import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.User;
import com.google.common.base.MoreObjects;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.function.Supplier;
import org.acegisecurity.GrantedAuthority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBambooUser
implements BambooUser {
    public static final String DEFAULT_USERS_GROUP = "bamboo-user";
    public static final String DEFAULT_ADMIN_GROUP = "bamboo-admin";
    private final User user;
    private final Supplier<GrantedAuthority[]> authoritiesSupplier;
    private final AccessToken accessToken;

    @Deprecated
    public DefaultBambooUser(User user) {
        this(user, () -> new GrantedAuthority[0]);
    }

    public DefaultBambooUser(@NotNull User user, @NotNull Supplier<GrantedAuthority[]> authoritiesSupplier) {
        this.user = user;
        this.authoritiesSupplier = authoritiesSupplier;
        this.accessToken = null;
    }

    public DefaultBambooUser(@NotNull User user, @NotNull Supplier<GrantedAuthority[]> authoritiesSupplier, @Nullable AccessToken accessToken) {
        this.user = user;
        this.authoritiesSupplier = authoritiesSupplier;
        this.accessToken = accessToken;
    }

    @Nullable
    public String getJabberAddress() {
        return this.getUserProperty("bamboo.user.contact.jabber");
    }

    @Nullable
    private String getUserProperty(String propertyKey) {
        PropertySet propertySet = ((BambooUserManager)ComponentAccessor.BAMBOO_USER_MANAGER.get()).getPropertySet(this.user);
        return propertySet == null ? null : propertySet.getString(propertyKey);
    }

    public String getNotificationPreference() {
        return (String)MoreObjects.firstNonNull((Object)this.getUserProperty("bamboo.user.contact.preference"), (Object)"both");
    }

    public String getNotificationTransportPreference() {
        return (String)MoreObjects.firstNonNull((Object)this.getUserProperty("bamboo.user.contact.transportPreference"), (Object)"multipart");
    }

    public User getUser() {
        return this.user;
    }

    public String getName() {
        return this.user.getName();
    }

    public String getFullName() {
        return this.user.getFullName();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public int hashCode() {
        return this.user.hashCode();
    }

    public boolean equals(Object o) {
        return this.user.equals(o);
    }

    @NotNull
    public GrantedAuthority[] getAuthorities() {
        return this.authoritiesSupplier.get();
    }

    public String getPassword() {
        return null;
    }

    public String getUsername() {
        return this.user.getName();
    }

    public boolean isAccountNonExpired() {
        return false;
    }

    public boolean isAccountNonLocked() {
        return false;
    }

    public boolean isCredentialsNonExpired() {
        return false;
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    @Nullable
    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public String toString() {
        return this.user.toString();
    }
}

