/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user;

import com.atlassian.bamboo.hibernate.HibernateEntityObject;
import com.atlassian.bamboo.user.LoginInformation;
import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="AUTH_ATTEMPT_INFO")
@BatchSize(size=100)
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="ID"))
public class LoginInformationImpl
extends HibernateEntityObject
implements LoginInformation {
    public static final int USERNAME_MAX_LENGTH = 255;
    @Column(name="USER_NAME", unique=true, length=255, nullable=false)
    private String userName;
    @Column(name="AUTH_COUNT")
    private int authenticationCount;
    @Column(name="LAST_AUTH_TIMESTAMP", nullable=false)
    private Date lastAuthenticationTimestamp;

    public LoginInformationImpl() {
        this(null);
    }

    public LoginInformationImpl(String userName) {
        this.userName = userName;
        this.lastAuthenticationTimestamp = new Date();
    }

    @NotNull
    public String getUserName() {
        return this.userName;
    }

    public int getAuthenticationCount() {
        return this.authenticationCount;
    }

    @NotNull
    public Date getLastAuthenticationTimestamp() {
        return this.lastAuthenticationTimestamp;
    }

    public void incrementAuthAttemptCount() {
        ++this.authenticationCount;
    }

    public void resetAuthAttemptCount() {
        this.authenticationCount = 0;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setAuthenticationCount(int authenticationCount) {
        this.authenticationCount = authenticationCount;
    }

    public void setLastAuthenticationTimestamp(Date lastAuthenticationTimestamp) {
        this.lastAuthenticationTimestamp = lastAuthenticationTimestamp;
    }
}

