/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.CaptchaConfiguration;
import com.atlassian.bamboo.user.LoginInformation;
import com.atlassian.bamboo.user.LoginInformationDao;
import com.atlassian.bamboo.user.LoginInformationImpl;
import com.atlassian.bamboo.user.LoginInformationManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoginInformationManagerImpl
implements LoginInformationManager {
    private static final Logger log = Logger.getLogger(LoginInformationManagerImpl.class);
    private final LoginInformationDao loginInformationDao;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public LoginInformationManagerImpl(@NotNull LoginInformationDao loginInformationDao, @NotNull AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.loginInformationDao = loginInformationDao;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public boolean isElevatedSecurityCheckRequired(String userName) {
        LoginInformation loginInformation = this.loginInformationDao.getLoginInformationByUserName(userName);
        return this.isThresholdExceeded(loginInformation);
    }

    public boolean incrementFailedCountAndCheckThreshold(@NotNull String userName) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return false;
        }
        this.validateUsername(userName);
        LoginInformation loginInformation = this.loginInformationDao.getLoginInformationByUserName(userName);
        if (loginInformation == null) {
            loginInformation = new LoginInformationImpl(userName);
        }
        loginInformation.incrementAuthAttemptCount();
        log.debug((Object)("Authentication attempts for " + userName + ": " + loginInformation.getAuthenticationCount()));
        try {
            this.loginInformationDao.save(loginInformation);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        boolean thresholdExceeded = this.isThresholdExceeded(loginInformation);
        if (thresholdExceeded) {
            log.info((Object)("Login failure threshold exceeded for " + userName + ", a CAPTCHA challenge will be issued."));
        }
        return thresholdExceeded;
    }

    public int getFailedLoginAttemptsCount(@Nullable String userName) {
        if (userName != null) {
            LoginInformation loginInformation = this.loginInformationDao.getLoginInformationByUserName(userName);
            return loginInformation != null ? loginInformation.getAuthenticationCount() : 0;
        }
        return 0;
    }

    public void resetFailedLoginAttemptsCount(@Nullable String userName) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return;
        }
        this.validateUsername(userName);
        LoginInformation loginInformation = this.loginInformationDao.getLoginInformationByUserName(userName);
        if (loginInformation != null) {
            loginInformation.resetAuthAttemptCount();
            try {
                this.loginInformationDao.save(loginInformation);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void validateUsername(@NotNull String userName) {
        if (StringUtils.length((CharSequence)userName) > 255) {
            throw new IllegalArgumentException("Username is too long");
        }
    }

    private boolean isThresholdExceeded(@Nullable LoginInformation loginInformation) {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        CaptchaConfiguration configuration = administrationConfiguration.getCaptchaConfiguration();
        return loginInformation != null && configuration.isEnableCaptcha() && loginInformation.getAuthenticationCount() >= configuration.getMaxLoginAttempts();
    }
}

