/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user;

import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.UserService;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.struts.TextProvider;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;

public class UserServiceImpl
implements UserService {
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private BambooUserManager userManager;
    @Inject
    private TextProvider textProvider;
    @Inject
    private GroupManager groupManager;
    private static final Pattern VALID_GROUP_NAME_PATTERN = Pattern.compile("[a-z|@|_|-|\\.|0-9|-]*");

    public List<Group> getGroup(String name) throws WebValidationException {
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION)) {
            throw new UnauthorisedException("No system administration permissions");
        }
        BambooValidationUtils.validate(StringUtils.isNotBlank((CharSequence)name), () -> this.textProvider.getText("group.groupName.error.required"));
        Group group = this.userManager.getGroup(name);
        if (group == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new Group[]{group});
    }

    public Group createGroup(String name) throws WebValidationException {
        if (!this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION)) {
            throw new UnauthorisedException("No system administration permissions");
        }
        BambooValidationUtils.validate(this.groupManager.isCreative(), () -> this.textProvider.getText("user.admin.no.create.directory.permissions"));
        BambooValidationUtils.checkErrors(this.validate(name));
        BambooValidationUtils.validateField("name", this.userManager.getGroup(name) == null, () -> this.textProvider.getText("group.groupName.error.duplicate"));
        return this.userManager.createGroup(name);
    }

    private ErrorCollection validate(String name) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)name)) {
            errorCollection.addError("name", this.textProvider.getText("group.groupName.error.required"));
            return errorCollection;
        }
        if (!VALID_GROUP_NAME_PATTERN.matcher(name).matches()) {
            errorCollection.addError("name", this.textProvider.getText("group.groupName.error.invalid"));
        }
        return errorCollection;
    }
}

