/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.cleanup;

import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityCleanupService;
import com.atlassian.bamboo.utils.SystemProperty;
import java.util.Date;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class CrowdDeletedEntityCleanupJob
implements Job {
    private static final Logger log = Logger.getLogger(CrowdDeletedEntityCleanupJob.class);
    private static final int BATCH_SIZE = 500;
    @Inject
    private CrowdDeletedEntityCleanupService crowdDeletedEntityCleanupService;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            boolean anythingProcessed;
            int timeoutInDays = (int)SystemProperty.CROWD_DELETED_ENTITY_TIMEOUT_DAYS.getTypedValue();
            log.info((Object)String.format("Cleaning up after Crowd entities deleted %d days ago", timeoutInDays));
            Date timeoutThreshold = DateTime.now().minusDays(timeoutInDays).toDate();
            while (anythingProcessed = this.crowdDeletedEntityCleanupService.runCleanup(timeoutThreshold, 500)) {
            }
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

