/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.cleanup;

import com.atlassian.bamboo.schedule.BambooScheduler;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityCleanupJob;
import com.atlassian.bamboo.utils.SystemProperty;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class CrowdDeletedEntityCleanupScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(CrowdDeletedEntityCleanupScheduler.class);
    private static final String GROUP_NAME = "CrowdDeletedEntityCleanupGroup";
    private static final String JOB_TRIGGER_NAME = "CrowdDeletedEntityCleanupJobTrigger";
    private static final String JOB_NAME = "CrowdDeletedEntityCleanupJob";
    private static final JobKey JOB_KEY = new JobKey("CrowdDeletedEntityCleanupJob", "CrowdDeletedEntityCleanupGroup");
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("CrowdDeletedEntityCleanupJobTrigger", "CrowdDeletedEntityCleanupGroup");
    private final Scheduler scheduler;

    @Inject
    public CrowdDeletedEntityCleanupScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void initialiseSchedule() {
        try {
            int cleanupHour = (int)Math.floorMod(SystemProperty.CROWD_DELETED_ENTITY_CLEANUP_HOUR.getTypedValue(), 24L);
            log.info((Object)String.format("Scheduling deleted Crowd entities cleanup at %d:00", cleanupHour));
            JobDetail jobDetail = JobBuilder.newJob(CrowdDeletedEntityCleanupJob.class).withIdentity(JOB_KEY).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)cleanupHour, (int)0)).forJob(JOB_KEY).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (NumberFormatException | SchedulerException e) {
            log.error((Object)String.format("Unable to schedule %s", JOB_NAME), e);
        }
    }
}

