/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.cleanup;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntity;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityCleanupService;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityDao;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CrowdDeletedEntityCleanupServiceImpl
implements CrowdDeletedEntityCleanupService {
    private static final Logger log = Logger.getLogger(CrowdDeletedEntityCleanupServiceImpl.class);
    private final BambooUserManager bambooUserManager;
    private final CrowdDeletedEntityDao crowdDeletedEntityDao;

    @Inject
    public CrowdDeletedEntityCleanupServiceImpl(BambooUserManager bambooUserManager, CrowdDeletedEntityDao crowdDeletedEntityDao) {
        this.bambooUserManager = bambooUserManager;
        this.crowdDeletedEntityDao = crowdDeletedEntityDao;
    }

    public boolean runCleanup(@NotNull Date timeoutThreshold, int batchSize) {
        boolean anythingProcessed;
        Collection entitiesToProcess = this.crowdDeletedEntityDao.findAllDeletedBefore(timeoutThreshold, batchSize);
        boolean bl = anythingProcessed = !entitiesToProcess.isEmpty();
        if (anythingProcessed) {
            log.debug((Object)String.format("Processing a batch of %d entities...", entitiesToProcess.size()));
            for (CrowdDeletedEntity entity : entitiesToProcess) {
                this.processEntity(entity);
            }
        } else {
            log.debug((Object)"Batch returned no entities to be processed...");
        }
        return anythingProcessed;
    }

    private void processEntity(@NotNull CrowdDeletedEntity entity) {
        log.trace((Object)String.format("Processing of entity %s (%s) started", entity.getEntityName(), entity.getEntityType()));
        switch (entity.getEntityType()) {
            case USER: {
                User user = this.bambooUserManager.getUser(entity.getEntityName());
                if (user == null) {
                    log.debug((Object)String.format("Cleaning up after deleted user %s", entity.getEntityName()));
                    this.bambooUserManager.cleanupRemovedUserReferences(entity.getEntityName());
                    break;
                }
                log.debug((Object)String.format("User %s still exists, skipping cleanup", entity.getEntityName()));
                break;
            }
            case GROUP: {
                Group group = this.bambooUserManager.getGroup(entity.getEntityName());
                if (group == null) {
                    log.debug((Object)String.format("Cleaning up after deleted group %s", entity.getEntityName()));
                    this.bambooUserManager.cleanupRemovedGroupReferences(entity.getEntityName());
                    break;
                }
                log.debug((Object)String.format("Group %s still exists, skipping cleanup", entity.getEntityName()));
                break;
            }
            default: {
                log.warn((Object)String.format("Unknown type %s of entity %s, skipping cleanup", entity.getEntityType(), entity.getEntityName()));
            }
        }
        this.crowdDeletedEntityDao.delete((BambooObject)entity);
        log.trace((Object)String.format("Processing of entity %s (%s) finished", entity.getEntityName(), entity.getEntityType()));
    }
}

