/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.cleanup;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntity;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityDao;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityImpl;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class CrowdDeletedEntityEventListener {
    private static final Logger log = Logger.getLogger(CrowdDeletedEntityEventListener.class);
    private static final int THREAD_POOL_SIZE = (int)SystemProperty.CROWD_DELETED_ENTITY_LISTENER_THREADS.getTypedValue();
    private static final ThreadFactory THREAD_FACTORY = new CustomizableThreadFactory("CrowdDeletedEntityEventListener-");
    private final Executor executor = Executors.newFixedThreadPool(THREAD_POOL_SIZE, THREAD_FACTORY);
    private final CrowdDeletedEntityDao crowdDeletedEntityDao;

    @Inject
    public CrowdDeletedEntityEventListener(CrowdDeletedEntityDao crowdDeletedEntityDao) {
        this.crowdDeletedEntityDao = crowdDeletedEntityDao;
    }

    @EventListener
    public void onUsersDeleted(@NotNull UsersDeletedEvent usersDeletedEvent) {
        Collection userNames = usersDeletedEvent.getUsernames();
        Date now = new Date();
        this.getExecutor().execute(() -> this.processDeletedEntities(CrowdDeletedEntity.EntityType.USER, userNames, now));
    }

    @EventListener
    public void onGroupDeleted(@NotNull GroupDeletedEvent groupDeletedEvent) {
        List<String> groupNames = Collections.singletonList(groupDeletedEvent.getGroupName());
        Date now = new Date();
        this.getExecutor().execute(() -> this.processDeletedEntities(CrowdDeletedEntity.EntityType.GROUP, groupNames, now));
    }

    private void processDeletedEntities(@NotNull CrowdDeletedEntity.EntityType entityType, @NotNull Collection<String> entityNames, @NotNull Date deletionDate) {
        log.debug((Object)String.format("Registering deletion of %d entities of type %s", entityNames.size(), entityType));
        long failures = entityNames.stream().map(entityName -> this.processDeletedEntity(entityType, (String)entityName, deletionDate)).filter(Boolean.FALSE::equals).count();
        if (failures > 0L) {
            Level logLevel = failures == 1L ? Level.WARN : Level.ERROR;
            log.log((Priority)logLevel, (Object)String.format("Could not register deletion of %d entities of type %s", failures, entityType));
        }
    }

    private boolean processDeletedEntity(@NotNull CrowdDeletedEntity.EntityType entityType, @NotNull String entityName, @NotNull Date deletionDate) {
        try {
            log.trace((Object)String.format("Registering deletion of %s %s", entityType, entityName));
            CrowdDeletedEntity entity = Optional.ofNullable(this.crowdDeletedEntityDao.findByTypeAndName(entityType, entityName)).orElseGet(() -> new CrowdDeletedEntityImpl(entityType, entityName));
            entity.setDeletionDate(deletionDate);
            this.crowdDeletedEntityDao.save((BambooObject)entity);
            return true;
        }
        catch (RuntimeException e) {
            log.debug((Object)String.format("Error while trying to register deletion of %s %s", entityType, entityName), (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    public Executor getExecutor() {
        return this.executor;
    }
}

