/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.gravatar;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.user.gravatar.GravatarDefaultImage;
import com.atlassian.bamboo.user.gravatar.GravatarDownloadException;
import com.atlassian.bamboo.user.gravatar.GravatarRating;
import com.atlassian.bamboo.user.gravatar.GravatarService;
import com.atlassian.bamboo.util.UrlBuilder;
import com.atlassian.bamboo.util.UrlUtils;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GravatarServiceImpl
implements GravatarService {
    private static final Logger log = Logger.getLogger(GravatarServiceImpl.class);
    private static final GravatarRating DEFAULT_RATING = GravatarRating.GENERAL_AUDIENCES;
    private static final GravatarDefaultImage DEFAULT_IMAGE = GravatarDefaultImage.MM;
    private static final int DEFAULT_SIZE = 25;
    private final ResettableLazyReference<String> gravatarServerUrl = new ResettableLazyReference<String>(){

        protected String create() throws Exception {
            return GravatarServiceImpl.this.administrationConfigurationAccessor.getAdministrationConfiguration().getGravatarServerUrl();
        }
    };
    private final ResettableLazyReference<Boolean> gravatarEnabled = new ResettableLazyReference<Boolean>(){

        protected Boolean create() throws Exception {
            return GravatarServiceImpl.this.administrationConfigurationAccessor.getAdministrationConfiguration().isGravatarSupportEnabled();
        }
    };
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public GravatarServiceImpl(AdministrationConfigurationPersister administrationConfigurationPersister, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    @Nullable
    public String getGravatarUrl(@Nullable String email, int size) {
        if (((Boolean)this.gravatarEnabled.get()).booleanValue()) {
            if (email == null || StringUtils.isBlank((CharSequence)email)) {
                email = "default_gravatar";
            }
            String emailHash = DigestUtils.md5Hex((String)email.toLowerCase().trim());
            UrlBuilder builder = new UrlBuilder();
            builder.setUrlBase(this.getGravatarServerUrl() + emailHash + ".jpg");
            builder.addParameter("s", Integer.toString(size > 0 ? size : 25));
            builder.addParameter("r", DEFAULT_RATING.getCode());
            builder.addParameter("d", DEFAULT_IMAGE.getCode());
            return builder.toString();
        }
        return null;
    }

    @Nullable
    public String getGravatarUrl(@Nullable String email) {
        return this.getGravatarUrl(email, 25);
    }

    @Nullable
    public String getDefaultGravatarUrl(int size) {
        return this.getGravatarUrl("default_gravatar", size);
    }

    /*
     * Loose catch block
     */
    public byte[] download(String email, int size) throws GravatarDownloadException {
        InputStream stream = null;
        try {
            URL url = new URL(this.getGravatarUrl(email, size));
            stream = url.openStream();
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            IOUtils.closeQuietly((InputStream)stream);
            return byArray;
        }
        catch (FileNotFoundException e) {
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e2) {
            throw new GravatarDownloadException(e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public void setGravatarSupported(boolean enabled, @NotNull String newUrl) {
        newUrl = UrlUtils.appendSlashIfDoesntExist((String)newUrl);
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        administrationConfiguration.setGravatarSupportEnabled(enabled);
        administrationConfiguration.setGravatarServerUrl(newUrl);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        this.gravatarEnabled.reset();
        this.gravatarServerUrl.reset();
    }

    public boolean isGravatarSupportEnabled() {
        return (Boolean)this.gravatarEnabled.get();
    }

    @NotNull
    public String getGravatarServerUrl() {
        if (StringUtils.isEmpty((CharSequence)((CharSequence)this.gravatarServerUrl.get()))) {
            return "https://secure.gravatar.com/avatar/";
        }
        return (String)this.gravatarServerUrl.get();
    }
}

