/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.user.rename;

import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.user.rename.UserRenameEvent;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.event.api.EventListener;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class UserRenameInNotifications {
    private static final Logger log = Logger.getLogger(UserRenameInNotifications.class);
    private final NotificationManager notificationManager;
    private final CachedPlanManager cachedPlanManager;

    public UserRenameInNotifications(@NotNull NotificationManager notificationManager, @NotNull CachedPlanManager cachedPlanManager) {
        this.notificationManager = notificationManager;
        this.cachedPlanManager = cachedPlanManager;
    }

    @EventListener
    public void onRenameUser(@NotNull UserRenameEvent userRenameEvent) {
        log.debug((Object)("Received user rename event: " + userRenameEvent));
        this.updateNotificationRules(userRenameEvent);
    }

    private void updateNotificationRules(@NotNull UserRenameEvent userRenameEvent) {
        List allChains = this.cachedPlanManager.getPlans(ImmutableChain.class);
        log.debug((Object)("Updating notification rules for " + allChains.size() + " chains"));
        int totalUpdated = 0;
        for (ImmutableChain chain : allChains) {
            totalUpdated += this.updateNotificationSet(chain.getNotificationSet(), userRenameEvent.getOldUserName(), userRenameEvent.getNewUserName());
        }
        log.debug((Object)"Updating system notification rules");
        log.debug((Object)("Updated " + (totalUpdated += this.updateNotificationSet(this.notificationManager.createOrGetSystemNotificationSet(), userRenameEvent.getOldUserName(), userRenameEvent.getNewUserName())) + " notification rules"));
    }

    private int updateNotificationSet(@NotNull NotificationSet notificationSet, @NotNull String oldUserName, @NotNull String newUserName) {
        Predicate<NotificationRule> isNotificationForRenamedUser = BambooPredicates.hasNotificationRuleRecipientType("com.atlassian.bamboo.plugin.system.notifications:recipient.user").and(BambooPredicates.hasNotificationRuleRecipient(oldUserName));
        List userNotificationRules = notificationSet.getNotificationRules().stream().filter(isNotificationForRenamedUser).collect(Collectors.toList());
        for (NotificationRule notificationRule : userNotificationRules) {
            notificationRule.setRecipient(newUserName);
        }
        int updatedEntries = userNotificationRules.size();
        if (updatedEntries > 0) {
            this.notificationManager.saveNotificationSet(notificationSet);
        }
        return updatedEntries;
    }
}

