/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooCollectionUtils {
    private static final Logger log = Logger.getLogger(BambooCollectionUtils.class);
    private static final String listItemPattern = "\\[[^\\[\\]]*\\]";

    private BambooCollectionUtils() {
    }

    @NotNull
    public static List<String> stringToCollection(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return Collections.emptyList();
        }
        Pattern pattern = Pattern.compile(listItemPattern);
        Matcher matcher = pattern.matcher(s);
        ArrayList<String> toReturn = new ArrayList<String>();
        int foundUpTo = 0;
        while (matcher.find(foundUpTo)) {
            String item = matcher.group();
            item = StringUtils.replace((String)item, (String)"[", (String)"");
            item = StringUtils.replace((String)item, (String)"]", (String)"");
            toReturn.add(item);
            foundUpTo = matcher.end();
        }
        return toReturn;
    }

    @NotNull
    public static List<String> stringArrayToList(@Nullable String[] s) {
        if (s == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])s);
    }

    @NotNull
    public static Set<String> stringArrayToHashSet(@Nullable String[] values) {
        if (values == null) {
            return new HashSet<String>();
        }
        return Sets.newHashSet((Object[])values);
    }

    @Nullable
    public static <T> List<T> removeDuplicates(@Nullable List<T> input) {
        if (CollectionUtils.isEmpty(input)) {
            return input;
        }
        return Lists.newArrayList((Iterable)Sets.newHashSet(input));
    }

    @Nullable
    public static <T extends Comparable<? super T>> List<T> removeDuplicatesAndSort(List<T> input) {
        List<T> output = BambooCollectionUtils.removeDuplicates(input);
        if (output != null) {
            Collections.sort(output);
        }
        return output;
    }

    @Nullable
    public static <T> List<T> removeDuplicatesAndSort(List<T> input, @NotNull Comparator<? super T> c) {
        List<T> output = BambooCollectionUtils.removeDuplicates(input);
        if (output != null) {
            Collections.sort(output, c);
        }
        return output;
    }

    @Nullable
    public static List<String> convertToList(@Nullable String s) {
        if (s != null) {
            String[] strings = s.split(",");
            ArrayList<String> list = new ArrayList<String>(strings.length);
            for (String s1 : strings) {
                if (!StringUtils.isNotBlank((CharSequence)s1)) continue;
                list.add(s1.trim());
            }
            return list;
        }
        return null;
    }

    @NotNull
    public static <T> List<T> subtract(@NotNull Collection<T> a, @NotNull Collection<T> b) {
        ArrayList result = Lists.newArrayList(a);
        result.removeAll(b);
        return result;
    }

    public static <K, V extends Comparable<? super V>> List<Map.Entry<K, V>> sortByValue(Map<K, V> map) {
        return map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue).reversed()).collect(Collectors.toCollection(LinkedList::new));
    }

    public static <E> boolean addIgnoreNull(@NotNull Collection<? super E> collection, @Nullable E element) {
        return element != null && collection.add(element);
    }

    @Nullable
    public static <E> E get(@NotNull List<? extends E> list, int index) {
        if (index < list.size()) {
            return list.get(index);
        }
        return null;
    }

    @NotNull
    public static <T> List<T> nullToEmptyImmutable(@Nullable List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    @NotNull
    public static <T> Set<T> nullToEmptyImmutable(@Nullable Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    @NotNull
    public static <K, V> Map<K, V> nullToEmptyImmutable(@Nullable Map<K, V> map) {
        return map != null ? map : Collections.emptyMap();
    }

    public static <T> boolean contains(@Nullable Collection<T> collection, Object object) {
        return collection != null && collection.contains(object);
    }

    @NotNull
    public static <T> ImmutableList<T> newImmutableList(@Nullable Collection<T> collection) {
        return collection == null ? ImmutableList.of() : ImmutableList.copyOf(collection);
    }

    @NotNull
    public static <T> ImmutableSet<T> newImmutableSet(@Nullable Iterable<T> set) {
        return set == null ? ImmutableSet.of() : ImmutableSet.copyOf(set);
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        return collection == null ? new HashSet() : new HashSet<T>(collection);
    }

    @NotNull
    public static <T> Collection<T> getLastElements(@NotNull Collection<T> collection, int numberOfElements) {
        Preconditions.checkArgument((numberOfElements >= 0 ? 1 : 0) != 0, (Object)"Number of elements to obtain must be greater than or equal 0");
        Preconditions.checkArgument((numberOfElements <= collection.size() ? 1 : 0) != 0, (Object)"Number of elements to obtain must not be greater than collection size");
        return Lists.newArrayList((Iterable)Iterables.skip(collection, (int)(collection.size() - numberOfElements)));
    }
}

