/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.atlassian.bamboo.util.SharedTemporaryFiles;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import io.atlassian.util.concurrent.Lazy;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooFileUtils {
    private static final Logger log = Logger.getLogger(BambooFileUtils.class);
    private static final Supplier<File> tmpDirSupplier = () -> BambooFilenameUtils.shortenNameIfPossible((File)SystemUtils.getJavaIoTmpDir());
    public static final Supplier<File> JAVA_IO_SHORT_TMPDIR = Lazy.supplier(tmpDirSupplier);

    private BambooFileUtils() {
    }

    public static boolean isDirectoryImportant(@Nullable File directory) {
        if (directory == null) {
            return false;
        }
        String path = directory.getAbsolutePath();
        return path.equals("/") || path.equals("/tmp") || path.equals("C:\\tmp") || path.equals("C:") || path.equals("C:\\") || path.equals("C:\\Windows\\system32") || path.equals("C:\\Windows") || path.equals(System.getProperty("user.home")) || path.equals(new File("").getAbsolutePath());
    }

    public static boolean isDirectoryOrLinkToDirectory(File file) {
        boolean directoryExists = file.isDirectory();
        if (!directoryExists && !file.isFile()) {
            try {
                directoryExists = file.getCanonicalFile().isDirectory();
            }
            catch (IOException e) {
                log.warn((Object)("Couldn't get the canonical file for '" + file.getPath() + "'"), (Throwable)e);
            }
        }
        return directoryExists;
    }

    public static File createTempDirectory(@NotNull Object client) throws IOException {
        return BambooFileUtils.createTempDirectory(client.getClass().getName());
    }

    @Deprecated
    public static File createTempDirectory(@Nullable File parentDir, @NotNull String prefix) throws IOException {
        Path dir = ((File)MoreObjects.firstNonNull((Object)parentDir, (Object)SystemUtils.getJavaIoTmpDir())).toPath();
        return Files.createTempDirectory(dir, prefix, new FileAttribute[0]).toFile();
    }

    public static File createTempDirectory(@NotNull String prefix) throws IOException {
        return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
    }

    @NotNull
    @VisibleForTesting
    static File openSecureTempFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix, directory);
        BambooFiles.setAccessibleOnlyByOwner((Path)tempFile.toPath());
        tempFile.deleteOnExit();
        return tempFile;
    }

    @Deprecated
    public static File createSafeTempFile(@NotNull String name, @Nullable File dir) throws IOException {
        SecureTemporaryFiles.TemporaryFileSpec spec = SecureTemporaryFiles.builder().setName(name).setDir(dir).build();
        return SecureTemporaryFiles.create(spec);
    }

    @Deprecated
    public static File createSafeTempFile(@NotNull String prefix, @Nullable String suffix) throws IOException {
        return BambooFileUtils.createSafeTempFile(prefix, suffix, null);
    }

    @Deprecated
    public static File createSafeTempFile(@NotNull String prefix, @Nullable String suffix, @Nullable File dir) throws IOException {
        SecureTemporaryFiles.TemporaryFileSpec spec = SecureTemporaryFiles.builder().setPrefix(prefix).setSuffix(suffix).setDir(dir).build();
        return SecureTemporaryFiles.create(spec);
    }

    @Deprecated
    public static boolean setWritableByOwnerOnly(File file) {
        boolean nobodyWrites = BambooFileUtils.canNotSetPermissionsForOthers() || file.setWritable(false, false);
        boolean ownerWrites = file.setWritable(true, true);
        return nobodyWrites && ownerWrites;
    }

    @Deprecated
    public static boolean setReadableByOwnerOnly(File file) {
        boolean nobodyReads = BambooFileUtils.canNotSetPermissionsForOthers() || file.setReadable(false, false);
        boolean ownerReads = file.setReadable(true, true);
        return nobodyReads && ownerReads;
    }

    public static boolean setExecutableByOwnerOnly(File file) {
        boolean nobodyExecutes = BambooFileUtils.canNotSetPermissionsForOthers() || file.setExecutable(false, false);
        boolean ownerExecutes = file.setExecutable(true, true);
        return nobodyExecutes && ownerExecutes;
    }

    private static boolean canNotSetPermissionsForOthers() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    @NotNull
    public static File safeWriteStringToFile(@NotNull String string, @NotNull String prefix, @Nullable String suffix, @Nullable File directory) throws IOException {
        File createdTmpFile = BambooFileUtils.openSecureTempFile(prefix, suffix, directory);
        try (FileOutputStream fos = new FileOutputStream(createdTmpFile);){
            File openedTmpFile = new File(createdTmpFile.getCanonicalPath());
            boolean chmodSuccessful = BambooFileUtils.canChangePermissions(openedTmpFile);
            if (!chmodSuccessful) {
                throw new SecurityException("Unable to set ownership on file: " + openedTmpFile);
            }
            IOUtils.write((String)string, (OutputStream)fos);
        }
        return createdTmpFile;
    }

    private static boolean canChangePermissions(File file) {
        boolean ownerCannotWrite = file.setWritable(false, true);
        boolean ownerCanWrite = file.setWritable(true, true);
        return ownerCannotWrite && ownerCanWrite;
    }

    @NotNull
    public static List<String> splitPathToComponents(@NotNull String path) {
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(path);
        do {
            result.add(0, file.getName());
        } while ((file = file.getParentFile()) != null);
        return result;
    }

    @NotNull
    public static String pathFromComponents(String ... pathComponents) {
        File file = new File("");
        for (String pathComponent : pathComponents) {
            file = new File(file, pathComponent);
        }
        return file.getPath();
    }

    public static boolean contains(File file, Pattern pattern) throws IOException {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), decoder);
             BufferedReader br = new BufferedReader(isr);){
            while (true) {
                String line;
                if ((line = br.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        return false;
    }

    public static boolean containsRegex(@NotNull File file, @NotNull String regexToMatch) throws IOException {
        Pattern pattern = Pattern.compile(regexToMatch);
        return BambooFileUtils.contains(file, pattern);
    }

    public static String relativizePath(@NotNull File rootDirectory, @NotNull File workingDirectory, @Nullable String path) {
        if (path != null) {
            return BambooFileUtils.calculateRelativePath(workingDirectory, new File(rootDirectory, path));
        }
        return null;
    }

    public static String calculateRelativePath(@NotNull File directory, @NotNull File file) {
        return directory.toURI().relativize(file.toURI()).getPath();
    }

    public static void renameTo(File from, File to) throws IOException {
        if (from.isDirectory()) {
            FileUtils.moveDirectory((File)from, (File)to);
        } else {
            FileUtils.moveFile((File)from, (File)to);
        }
    }

    public static void moveDirectoryContentToDirectory(@NotNull File src, @NotNull File destDir, boolean createDestDir) throws IOException {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)destDir);
        if (!src.isDirectory()) {
            throw new IOException(src + " is not a directory");
        }
        if (!destDir.exists() && createDestDir && !destDir.mkdirs()) {
            throw new IOException("Unable to create " + destDir);
        }
        File[] files = src.listFiles();
        if (files != null) {
            for (File file : files) {
                FileUtils.moveToDirectory((File)file, (File)destDir, (boolean)false);
            }
        }
    }

    @Deprecated
    public static File getSharedTemporaryFile(@NotNull String content, @NotNull String prefix, @Nullable String suffix, boolean executable, @Nullable File directory) throws IOException {
        SharedTemporaryFiles.SharedTemporaryFileSpec temporaryFileSpec = SharedTemporaryFiles.builder(content).setPrefix(prefix).setSuffix(suffix).setExecutable(executable).setDir(directory).build();
        return SharedTemporaryFiles.create(temporaryFileSpec);
    }

    @Deprecated
    public static File getSharedTemporaryFile(@NotNull SharedTemporaryFiles.SharedTemporaryFileSpec temporaryFileSpec) throws IOException {
        return SharedTemporaryFiles.create(temporaryFileSpec);
    }

    public static Supplier<File> persistentFileSupplier(final Supplier<File> fileSupplier) {
        return new Supplier<File>(){
            private File file;

            @Override
            public synchronized File get() {
                if (this.file != null && this.file.exists()) {
                    return this.file;
                }
                this.file = (File)fileSupplier.get();
                return this.file;
            }
        };
    }

    public static Supplier<File> createDirectorySupplier(final Supplier<File> delegate) {
        return new Supplier<File>(){
            private File file;

            @Override
            public File get() {
                if (this.file != null && this.file.isDirectory()) {
                    return this.file;
                }
                this.file = (File)delegate.get();
                Preconditions.checkState((this.file.isDirectory() || this.file.mkdirs() ? 1 : 0) != 0, (String)"Unable to create directory %s", (Object[])new Object[]{this.file.getAbsolutePath()});
                return this.file;
            }
        };
    }

    public static Supplier<File> createDirectorySupplier(File directory) {
        return BambooFileUtils.createDirectorySupplier(() -> directory);
    }

    public static IOFileFilter regexPathFilter(@NotNull String pathPattern) {
        final Pattern pattern = Pattern.compile(pathPattern);
        return new AbstractFileFilter(){

            public boolean accept(File file) {
                return pattern.matcher(file.getAbsolutePath()).matches();
            }
        };
    }

    @Deprecated
    public static File newFileUnderParent(@NotNull File parent, @NotNull String child) throws IOException {
        String canonicalParent = parent.getCanonicalPath();
        File canonicalFile = new File(parent, child).getCanonicalFile();
        if (!canonicalFile.getPath().startsWith(canonicalParent)) {
            throw new IllegalArgumentException("Creation of " + child + " under " + parent + " would result in parent directory traversal");
        }
        return canonicalFile;
    }

    @Deprecated
    public static boolean isContainsDirectoryTraversalString(@Nullable String name) {
        return BambooFilenameUtils.containsDirectoryTraversalString((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFileWithSize(@NotNull File file, long size) throws IOException {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"File size must be a non-negative number of bytes");
        File parentFile = file.getParentFile();
        if (parentFile != null && !file.equals(parentFile)) {
            Preconditions.checkArgument((boolean)parentFile.exists(), (Object)"Parent directory of the file doesn't exist");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(size);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(randomAccessFile);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)randomAccessFile);
    }

    public static void createDirectoryIfNotExists(File directory) throws IllegalStateException {
        Preconditions.checkState((directory.exists() || directory.mkdirs() ? 1 : 0) != 0, (String)"Can't create directory: %s", (Object[])new Object[]{directory.getAbsolutePath()});
    }

    @NotNull
    public static Iterable<File> getFilesFromFileSet(final @NotNull FileSet fileSet) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return Iterators.transform((Iterator)fileSet.iterator(), FileResource::getFile);
            }
        };
    }

    @NotNull
    public static File getSingleFileFromDirectory(@NotNull File directory) throws IOException {
        Preconditions.checkArgument((boolean)directory.exists(), (String)"The directory doesn't exist: %s", (Object[])new Object[]{directory.getCanonicalPath()});
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"The given file was not a directory: %s", (Object[])new Object[]{directory.getCanonicalPath()});
        File[] directoryFiles = directory.listFiles();
        Preconditions.checkArgument((directoryFiles != null ? 1 : 0) != 0, (String)"Couldn't obtain directory content: %s", (Object[])new Object[]{directory.getCanonicalPath()});
        Preconditions.checkArgument((directoryFiles.length == 1 ? 1 : 0) != 0, (String)"Expected a single file within the directory, found %s files: %s", (Object[])new Object[]{directoryFiles.length, directory.getCanonicalPath()});
        return directoryFiles[0];
    }

    @Deprecated
    public static void deleteDirectory(@NotNull File directory) throws IOException {
        BambooPathUtils.deleteDirectory((Path)directory.toPath());
    }

    @Deprecated
    public static void cleanDirectory(@NotNull File directory) throws IOException {
        Path rootPath = directory.toPath();
        BambooPathUtils.cleanDirectory((Path)rootPath);
    }

    @Deprecated
    public static boolean deleteQuietly(@Nullable File fileOrDir) {
        if (fileOrDir == null) {
            return false;
        }
        return BambooPathUtils.deleteQuietly((Path)fileOrDir.toPath());
    }

    @Deprecated
    public static void forceDelete(@NotNull File file) throws IOException {
        BambooPathUtils.forceDelete((Path)file.toPath());
    }
}

