/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.spring.SpringProxy;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.config.db.HibernateConfig;
import com.google.common.base.Stopwatch;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.InvocationHandler;

public class BambooHibernateUtils {
    private static final Logger log = Logger.getLogger(BambooHibernateUtils.class);
    public static final AtomicInteger counter = new AtomicInteger();
    private static final String HIBERNATE_QUERY_LOGGER_NAME = "org.hibernate.SQL";
    private static final Duration LOG_INFO_THRESHOLD = Duration.ofSeconds(5L);
    private static final Duration LOG_WARN_THRESHOLD = Duration.ofSeconds(30L);
    private static final Duration LOG_ERROR_THRESHOLD = Duration.ofSeconds(60L);

    private BambooHibernateUtils() {
    }

    public static void enableSqlLogging() {
        Logger logger = LogManager.getLogger((String)HIBERNATE_QUERY_LOGGER_NAME);
        if (logger != null) {
            logger.setLevel(Level.DEBUG);
        }
    }

    public static void disableSqlLogging() {
        Logger logger = LogManager.getLogger((String)HIBERNATE_QUERY_LOGGER_NAME);
        if (logger != null) {
            logger.setLevel(Level.INFO);
        }
    }

    public static <T> T withSqlLogged(@NotNull Callable<T> callable, @Nullable String message) throws HibernateException {
        if (message == null) {
            message = "";
        }
        int logId = counter.incrementAndGet();
        Logger logger = LogManager.getLogger((String)HIBERNATE_QUERY_LOGGER_NAME);
        Level previousLevel = null;
        if (logger != null) {
            log.info((Object)("Query log session " + logId + " | start " + message));
            previousLevel = logger.getLevel();
            logger.setLevel(Level.DEBUG);
        }
        try {
            T t = callable.call();
            return t;
        }
        catch (Throwable t) {
            throw BambooObjectUtils.rethrowAnyCauseThatIsInstanceOf((Throwable)t, HibernateException.class);
        }
        finally {
            if (logger != null) {
                logger.setLevel(previousLevel);
                log.info((Object)("Query log session " + logId + " | end " + message));
            }
        }
    }

    public static List listWithSqlLogged(final @NotNull Criteria criteria, @Nullable String message) throws HibernateException {
        return BambooHibernateUtils.withSqlLogged(new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = criteria.list();
                log.info((Object)(result.size() + " objects retrieved"));
                return result;
            }
        }, message);
    }

    public static int getMaxConnectionPoolSize(@NotNull HibernateConfig hibernateConfig) {
        try {
            int maxConnectionPoolSize = Integer.parseInt(hibernateConfig.getHibernateProperties().getProperty("hibernate.c3p0.max_size", "15"));
            return Math.max(maxConnectionPoolSize - 2, 1);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public static int getConcurrentPoolSize(@NotNull HibernateConfig hibernateConfig) {
        try {
            return Math.min(Runtime.getRuntime().availableProcessors(), BambooHibernateUtils.getMaxConnectionPoolSize(hibernateConfig));
        }
        catch (NumberFormatException e) {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    public static <T> T createObjectWithId(Class<T> aClass, long id) {
        final Long idObject = id;
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                if (method.getName().equals("getId")) {
                    return idObject;
                }
                throw new UnsupportedOperationException("this object only supports the getId() method");
            }
        };
        return (T)SpringProxy.newProxyInstance(aClass, (Callback)invocationHandler);
    }

    public static <T> T timed(final T objectToTime) {
        return (T)SpringProxy.newProxyInstance(objectToTime.getClass(), (Callback)new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] objects) throws Throwable {
                Stopwatch stopwatch = Stopwatch.createStarted();
                try {
                    Object object = method.invoke(objectToTime, objects);
                    return object;
                }
                finally {
                    stopwatch.stop();
                    Priority level = BambooLogUtils.getLogLevel((Stopwatch)stopwatch, (Duration)LOG_INFO_THRESHOLD, (Duration)LOG_WARN_THRESHOLD, (Duration)LOG_ERROR_THRESHOLD);
                    if (log.isEnabledFor(level)) {
                        log.log(level, (Object)("Slow query " + BambooHibernateUtils.getFirstMeaningfulTrace() + " took " + stopwatch));
                    }
                }
            }
        });
    }

    private static StackTraceElement getFirstMeaningfulTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 1;
        while (++i < stackTrace.length) {
            if (stackTrace[i].getClassName().startsWith(BambooHibernateUtils.class.getName())) continue;
            --i;
            break;
        }
        while (++i < stackTrace.length) {
            if (stackTrace[i].getLineNumber() == -1) continue;
            return stackTrace[i];
        }
        return null;
    }

    public static void flushIfNeeded(Session session) {
        if (session.isDirty()) {
            session.flush();
        }
    }

    @NotNull
    public static Map<String, Pair<Object, Object>> getPropertyChanges(Object[] currentState, Object[] previousState, String[] propertyNames) {
        TreeMap<String, Pair<Object, Object>> result = new TreeMap<String, Pair<Object, Object>>();
        for (int i = 0; i < currentState.length; ++i) {
            if (previousState[i] == currentState[i] || Objects.equals(previousState[i], currentState[i])) continue;
            result.put(propertyNames[i], (Pair<Object, Object>)Pair.of((Object)previousState[i], (Object)currentState[i]));
        }
        return result;
    }

    @NotNull
    public static String describePropertyChanges(Map<String, Pair<Object, Object>> propertyChanges) {
        return propertyChanges.entrySet().stream().map(pc -> String.format("%s:%s->%s", pc.getKey(), ((Pair)pc.getValue()).getLeft(), ((Pair)pc.getValue()).getRight())).collect(Collectors.joining(", "));
    }

    @Nullable
    public static Object getPropertyByName(String name, String[] propertyNames, Object[] values) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyNames[i].equals(name)) continue;
            return values[i];
        }
        throw new IllegalArgumentException("Property [" + name + "] not found in " + Arrays.toString(propertyNames));
    }

    public static Session timed(final Session session) {
        return (Session)SpringProxy.newProxyInstance(Session.class, (Callback)new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] objects) throws Throwable {
                switch (method.getName()) {
                    case "getNamedQuery": 
                    case "createQuery": 
                    case "createCriteria": {
                        return BambooHibernateUtils.timed(method.invoke((Object)session, objects));
                    }
                }
                return method.invoke((Object)session, objects);
            }
        });
    }
}

