/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.utils.Pair;
import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class BambooMaps {
    private BambooMaps() {
    }

    public static <K, V> Map<K, V> newHashMapFrom(Iterable<? extends V> source, Function<V, Pair<K, V>> function) {
        HashMap map = new HashMap();
        BambooMaps.putAll(map, Iterables.transform(source, function));
        return map;
    }

    public static <K, V> Map<K, V> newLinkedHashMapWithLimitedSize(int maxSize) {
        return new LinkedHashMapWithLimitedSize(maxSize);
    }

    public static <K, V> void putAll(Map<K, ? super V> map, Iterable<Pair<K, V>> iterable) {
        for (Pair<K, V> pair : iterable) {
            map.put(pair.first, pair.second);
        }
    }

    public static <K, V> Map<K, V> mutableUniqueIndex(Iterable<? extends V> values, Function<? super V, ? extends K> indexGenerator) {
        HashMap<Object, V> map = new HashMap<Object, V>();
        for (V value : values) {
            map.put(indexGenerator.apply(value), value);
        }
        return map;
    }

    public static <K, V> LinkedHashMap<K, V> mutableLinkedUniqueIndex(Iterable<? extends V> values, Function<? super V, ? extends K> indexGenerator) {
        LinkedHashMap<Object, V> map = new LinkedHashMap<Object, V>();
        for (V value : values) {
            map.put(indexGenerator.apply(value), value);
        }
        return map;
    }

    public static <K, V> V populateMap(@NotNull Map<K, V> map, @NotNull V input, @NotNull Function<? super V, ? extends K> indexGenerator) {
        return map.put(indexGenerator.apply(input), input);
    }

    @NotNull
    public static <K, V> CacheLoader<? super K, Option<V>> nullMasquingLoader(final CacheLoader<? super K, ? extends V> nullReturningLoader) {
        return new CacheLoader<K, Option<V>>(){

            public Option<V> load(K key) throws Exception {
                Object maybeNull = nullReturningLoader.load(key);
                return Option.option((Object)maybeNull);
            }
        };
    }

    public static <K, V> Map<K, V> generateMap(final @NotNull Set<K> keys, final @NotNull Function<K, V> generator) {
        return new LinkedHashMap<K, V>(){
            {
                for (Object key : keys) {
                    this.put(key, generator.apply(key));
                }
            }
        };
    }

    public static <K, V> void prune(@NotNull Map<K, V> map, @NotNull Predicate<Map.Entry<K, V>> predicate) {
        Iterator<Map.Entry<K, V>> entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<K, V> entry = entries.next();
            if (!predicate.test(entry)) continue;
            entries.remove();
        }
    }

    private static class LinkedHashMapWithLimitedSize<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        private LinkedHashMapWithLimitedSize(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

