/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.Narrow;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

public class BambooSpringUtils {
    private BambooSpringUtils() {
    }

    @NotNull
    public static TransactionTemplate readOnly(@NotNull TransactionTemplate transactionTemplate) {
        if (transactionTemplate.isReadOnly()) {
            return transactionTemplate;
        }
        return BambooSpringUtils.clone(transactionTemplate, null, true);
    }

    @NotNull
    public static TransactionTemplate readOnlyClone(@NotNull TransactionTemplate transactionTemplate) {
        return BambooSpringUtils.clone(transactionTemplate, null, true);
    }

    @NotNull
    public static TransactionTemplate requiresNew(@NotNull TransactionTemplate transactionTemplate) {
        if (transactionTemplate.getPropagationBehavior() == 3) {
            return transactionTemplate;
        }
        return BambooSpringUtils.clone(transactionTemplate, true, null);
    }

    @NotNull
    public static TransactionTemplate requiresNewClone(@NotNull TransactionTemplate transactionTemplate) {
        return BambooSpringUtils.clone(transactionTemplate, true, null);
    }

    @NotNull
    public static TransactionTemplate clone(@NotNull TransactionTemplate transactionTemplate, @Nullable Boolean requiresNewTx, @Nullable Boolean readOnly) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setIsolationLevel(transactionTemplate.getIsolationLevel());
        transactionDefinition.setName(transactionTemplate.getName());
        transactionDefinition.setTimeout(transactionTemplate.getTimeout());
        if (requiresNewTx == null) {
            transactionDefinition.setPropagationBehavior(transactionTemplate.getPropagationBehavior());
        } else {
            int propagation = requiresNewTx != false ? 3 : 0;
            transactionDefinition.setPropagationBehavior(propagation);
        }
        if (readOnly == null) {
            transactionDefinition.setReadOnly(transactionTemplate.isReadOnly());
        } else {
            transactionDefinition.setReadOnly(readOnly.booleanValue());
        }
        return new TransactionTemplate(transactionTemplate.getTransactionManager(), (TransactionDefinition)transactionDefinition);
    }

    public static Object unwrapIfProxy(@NotNull Object bean) throws Exception {
        if (AopUtils.isAopProxy((Object)bean) && bean instanceof Advised) {
            return BambooSpringUtils.unwrapIfProxy(((Advised)bean).getTargetSource().getTarget());
        }
        return bean;
    }

    public static <T> T autowireComponent(T object) {
        ContainerManager.autowireComponent(object);
        return object;
    }

    public static <T> T autowireComponent(@NotNull AutowireCapableBeanFactory beanFactory, @NotNull T o) {
        beanFactory.autowireBeanProperties(o, 1, false);
        return o;
    }

    @NotNull
    public static <T> T createCompleteComponent(@NotNull Class<T> objectClass) {
        Object component = Narrow.downTo((Object)ContainerManager.getInstance().getContainerContext().createCompleteComponent(objectClass), objectClass);
        Preconditions.checkNotNull((Object)component, (Object)("Unable do create Spring component of class " + objectClass));
        return (T)component;
    }
}

