/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.util.CallableResultCache;
import com.atlassian.bamboo.utils.BambooCallables;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@PublicApi
public final class CacheAwareness {
    private static final Logger log = Logger.getLogger(CacheAwareness.class);
    private static final InheritableThreadLocal<Set<CacheInfo>> disabledCachesThreadLocal = new InheritableThreadLocal<Set<CacheInfo>>(){

        @Override
        protected Set<CacheInfo> initialValue() {
            return new HashSet<CacheInfo>();
        }

        @Override
        protected Set<CacheInfo> childValue(Set<CacheInfo> parentValue) {
            if (parentValue != null && parentValue.size() > 0) {
                log.warn((Object)("Inheriting disabledCaches:" + Arrays.toString(parentValue.toArray())));
            }
            return this.initialValue();
        }
    };
    private static final ThreadLocal<Long> disabledCachesTimestampThreadLocal = ThreadLocal.withInitial(() -> 0L);
    public static final CacheInfo CHANGE_DETECTION = CacheAwareness.atlassianCacheId("CHANGE_DETECTION");
    public static final CacheInfo BRANCH_DETECTION = CacheAwareness.atlassianCacheId("BRANCH_DETECTION");
    public static final CacheInfo ANY = CacheAwareness.atlassianCacheId("ANY");

    private CacheAwareness() {
    }

    public static CacheInfo cacheInfo(String cachedDataType) {
        return new CacheInfo(cachedDataType);
    }

    public static <E1 extends Exception, E2 extends Exception, E3 extends Exception> void withValuesOlderThanTimestampReloaded(BambooRunnables.ThrowingX<E1, E2, E3> runnable, long timestamp, CacheInfo ... disabledCached) throws E2, E1, E3 {
        CacheAwareness.withValuesOlderThanTimestampReloaded(() -> {
            runnable.run();
            return null;
        }, timestamp, disabledCached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, E1 extends Exception, E2 extends Exception, E3 extends Exception> V withValuesOlderThanTimestampReloaded(BambooCallables.ThrowingX<V, E1, E2, E3> callable, long timestamp, CacheInfo ... disabledCaches) throws E2, E1, E3 {
        HashSet oldCacheInfos = Sets.newHashSet((Iterable)((Iterable)disabledCachesThreadLocal.get()));
        Long oldTimestamp = disabledCachesTimestampThreadLocal.get();
        try {
            if (disabledCaches != null) {
                ((Set)disabledCachesThreadLocal.get()).addAll(Arrays.asList(disabledCaches));
                disabledCachesTimestampThreadLocal.set(timestamp);
            }
            Object object = callable.call();
            return (V)object;
        }
        finally {
            if (oldCacheInfos.isEmpty()) {
                disabledCachesThreadLocal.remove();
                disabledCachesTimestampThreadLocal.set(0L);
            } else {
                disabledCachesThreadLocal.set(oldCacheInfos);
                disabledCachesTimestampThreadLocal.set(oldTimestamp);
            }
        }
    }

    public static <E1 extends Exception, E2 extends Exception, E3 extends Exception> void withValuesOlderThanTimestampReloaded(BambooRunnables.ThrowingX<E1, E2, E3> runnable, long timestamp, Iterable<CacheInfo> disabledCaches) throws E2, E1, E3 {
        CacheAwareness.withValuesOlderThanTimestampReloaded(runnable, timestamp, (CacheInfo[])Iterables.toArray(disabledCaches, CacheInfo.class));
    }

    public static Pair<Iterable<CacheInfo>, Long> getDisabledCachesTimestamp() {
        return Pair.make((Object)Sets.newHashSet((Iterable)((Iterable)disabledCachesThreadLocal.get())), (Object)disabledCachesTimestampThreadLocal.get());
    }

    static boolean isCacheReloadRequired(CallableResultCache<?> callableResultCache, long valueCreationTimestamp) {
        Set disabledCaches = (Set)disabledCachesThreadLocal.get();
        Long disabledTimestamp = disabledCachesTimestampThreadLocal.get();
        if (disabledCaches.isEmpty()) {
            return false;
        }
        if (disabledCaches.contains(ANY)) {
            return disabledTimestamp >= valueCreationTimestamp;
        }
        for (CacheInfo cache : callableResultCache.getCacheInfo()) {
            if (!disabledCaches.contains(cache)) continue;
            return disabledTimestamp >= valueCreationTimestamp;
        }
        return false;
    }

    private static CacheInfo atlassianCacheId(String id) {
        return new CacheInfo("com.atlassian.bamboo." + id);
    }

    public static final class CacheInfo {
        private final String id;

        private CacheInfo(@NotNull String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheInfo cacheInfo = (CacheInfo)o;
            return this.id.equals(cacheInfo.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return this.id;
        }
    }
}

