/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.utils.collections.AlwaysInvalidatingCacheDecorator;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class CallableResultCache<T> {
    private static final Logger log = Logger.getLogger(CallableResultCache.class);
    private final CacheAwareness.CacheInfo[] cacheIds;
    private final LoadingCache<CachedOperationId<T>, CachedOperationValue<T>> cache;
    private static final AtomicInteger sequence = new AtomicInteger();

    private CallableResultCache(LoadingCache<CachedOperationId<T>, CachedOperationValue<T>> cache, CacheAwareness.CacheInfo ... cacheIds) {
        this.cacheIds = cacheIds;
        this.cache = cache;
    }

    private static <T> CacheLoader<CachedOperationId<T>, CachedOperationValue<T>> loader() {
        return new CacheLoader<CachedOperationId<T>, CachedOperationValue<T>>(){

            public CachedOperationValue<T> load(CachedOperationId<T> key) throws Exception {
                long timeLoaded = System.currentTimeMillis();
                return new CachedOperationValue(key.getCallable().call(), timeLoaded);
            }
        };
    }

    public static <T> CallableResultCache<T> build(@NotNull CacheBuilder<Object, Object> builder) {
        CacheAwareness.CacheInfo cacheInfo = CacheAwareness.cacheInfo(CallableResultCache.class.getSimpleName() + "-" + sequence.incrementAndGet());
        return CallableResultCache.build(builder, cacheInfo);
    }

    public static <T> CallableResultCache<T> build(@NotNull CacheBuilder<Object, Object> builder, CacheAwareness.CacheInfo ... cacheIds) {
        LoadingCache<CachedOperationId<T>, CachedOperationValue<T>> cache = CallableResultCache.buildCache(builder);
        return new CallableResultCache<T>(cache, cacheIds);
    }

    public static <T> CallableResultCache<T> buildAlwaysInvalidating(@NotNull CacheBuilder<Object, Object> builder, CacheAwareness.CacheInfo ... cacheIds) {
        LoadingCache<CachedOperationId<T>, CachedOperationValue<T>> cache = CallableResultCache.buildCache(builder);
        return new CallableResultCache<T>(AlwaysInvalidatingCacheDecorator.wrap(cache), cacheIds);
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public T call(@NotNull Callable<T> callable, Object ... keys) {
        CachedOperationId<T> key = new CachedOperationId<T>(callable, keys);
        CachedOperationValue val = this.invalidateIfNeeded(key);
        if (val == null) {
            val = (CachedOperationValue)this.cache.getUnchecked(key);
        }
        return val != null ? (T)val.getValue() : null;
    }

    public T callChecked(@NotNull Callable<T> callable, Object ... keys) throws ExecutionException {
        CachedOperationId<T> key = new CachedOperationId<T>(callable, keys);
        CachedOperationValue val = this.invalidateIfNeeded(key);
        if (val == null) {
            val = (CachedOperationValue)this.cache.get(key);
        }
        return val != null ? (T)val.getValue() : null;
    }

    private CachedOperationValue<T> invalidateIfNeeded(CachedOperationId<T> key) {
        CachedOperationValue val = (CachedOperationValue)this.cache.getIfPresent(key);
        if (val != null && CacheAwareness.isCacheReloadRequired(this, val.getTimeLoaded())) {
            log.debug((Object)("Forcing invalidation on cache: " + Arrays.toString(this.cacheIds) + " by Thread " + Thread.currentThread().getName() + ", " + key.toString()));
            this.cache.invalidate(key);
            return null;
        }
        return val;
    }

    @NotNull
    CacheAwareness.CacheInfo[] getCacheInfo() {
        return this.cacheIds;
    }

    private static <T> LoadingCache<CachedOperationId<T>, CachedOperationValue<T>> buildCache(CacheBuilder<Object, Object> builder) {
        CacheLoader<CachedOperationId<T>, CachedOperationValue<T>> loader = CallableResultCache.loader();
        return builder.build(loader);
    }

    public static final class CachedOperationId<T> {
        private final Callable<T> callable;
        private final Object[] keys;

        public CachedOperationId(Callable<T> callable, Object ... keys) {
            this.callable = callable;
            this.keys = keys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedOperationId that = (CachedOperationId)o;
            return Arrays.equals(this.keys, that.keys);
        }

        public Callable<T> getCallable() {
            return this.callable;
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }

        public String toString() {
            return "CachedOperationId{keys=" + Arrays.toString(this.keys) + '}';
        }
    }

    private static final class CachedOperationValue<T> {
        private final T value;
        private final long timeLoaded;

        private CachedOperationValue(T value, long timeLoaded) {
            this.value = value;
            this.timeLoaded = timeLoaded;
        }

        T getValue() {
            return this.value;
        }

        long getTimeLoaded() {
            return this.timeLoaded;
        }
    }
}

