/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.annotations.ExperimentalApi;
import io.atlassian.fugue.Option;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;

@ExperimentalApi
public class OptionUnpackingMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, Option<V>> mapWithOptions;

    public OptionUnpackingMap(ConcurrentMap<K, Option<V>> mapWithOptions) {
        this.mapWithOptions = mapWithOptions;
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        Option vs = this.mapWithOptions.putIfAbsent(key, Option.option(value));
        return this.nullOrValue(vs);
    }

    @Nullable
    private V nullOrValue(@Nullable Option<V> option) {
        if (option != null) {
            return (V)option.getOrNull();
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.mapWithOptions.remove(key, Option.option((Object)value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.mapWithOptions.replace(key, Option.option(oldValue), Option.option(newValue));
    }

    @Override
    @Nullable
    public V replace(K key, V value) {
        Option orNull = this.mapWithOptions.replace(key, Option.option(value));
        return this.nullOrValue(orNull);
    }

    @Override
    public int size() {
        return this.mapWithOptions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapWithOptions.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mapWithOptions.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mapWithOptions.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)((Option)this.mapWithOptions.get(key)).getOrNull();
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Option put = this.mapWithOptions.put(key, Option.option(value));
        return this.nullOrValue(put);
    }

    @Override
    @Nullable
    public V remove(Object key) {
        return this.nullOrValue((Option)this.mapWithOptions.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.mapWithOptions.put(entry.getKey(), Option.option(entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.mapWithOptions.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mapWithOptions.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Option vs : this.mapWithOptions.values()) {
            values.add(vs.getOrNull());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry entry : this.mapWithOptions.entrySet()) {
            entrySet.add(this.newEntry(entry.getKey(), (Option)entry.getValue()));
        }
        return entrySet;
    }

    private Map.Entry<K, V> newEntry(K key, Option<V> value) {
        return new AbstractMap.SimpleEntry<K, Object>(key, value.getOrNull());
    }

    @Override
    public boolean equals(Object o) {
        return this.mapWithOptions.equals(o);
    }

    @Override
    public int hashCode() {
        return this.mapWithOptions.hashCode();
    }
}

