/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.HttpUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestCacheThreadLocal {
    private static final Logger log = Logger.getLogger(RequestCacheThreadLocal.class);
    public static final String CONTEXT_PATH_KEY = "bamboo.context.path";
    private static final String HTTP_REQUEST_KEY = "bamboo.http.request";
    private static final String HTTP_REQUEST_IS_MUTATIVE_KEY = "bamboo.http.request.isMutative";
    private static final String HTTP_RESPONSE_KEY = "bamboo.http.response";
    private static final ThreadLocal<Map<String, Object>> REQUEST_CACHE = new ThreadLocal();

    private RequestCacheThreadLocal() {
    }

    @NotNull
    public static Map<String, Object> getRequestCache() {
        Map<String, Object> requestCache = REQUEST_CACHE.get();
        if (requestCache != null) {
            return requestCache;
        }
        REQUEST_CACHE.set(new HashMap());
        return REQUEST_CACHE.get();
    }

    public static void setRequestCache(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        REQUEST_CACHE.set(map);
        RequestCacheThreadLocal.putHttpRequest(httpServletRequest, map);
        map.put(HTTP_REQUEST_IS_MUTATIVE_KEY, HttpUtils.canMethodMutateState((String)httpServletRequest.getMethod()));
        map.put(HTTP_RESPONSE_KEY, httpServletResponse);
        map.put(CONTEXT_PATH_KEY, httpServletRequest.getContextPath());
    }

    public static void clearRequestCache() {
        REQUEST_CACHE.remove();
    }

    @Nullable
    private static <T> T getIfCacheExists(String key) {
        Map<String, Object> requestCache = REQUEST_CACHE.get();
        if (requestCache != null) {
            return (T)requestCache.get(key);
        }
        return null;
    }

    @Nullable
    public static String getContextPath() {
        return (String)RequestCacheThreadLocal.getIfCacheExists(CONTEXT_PATH_KEY);
    }

    @Nullable
    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)RequestCacheThreadLocal.getIfCacheExists(HTTP_REQUEST_KEY);
    }

    @Nullable
    public static HttpServletResponse getResponse() {
        return (HttpServletResponse)RequestCacheThreadLocal.getIfCacheExists(HTTP_RESPONSE_KEY);
    }

    public static boolean canRequestMutateState() {
        Boolean isMutative = (Boolean)RequestCacheThreadLocal.getIfCacheExists(HTTP_REQUEST_IS_MUTATIVE_KEY);
        return Boolean.TRUE.equals(isMutative);
    }

    public static void update(@NotNull HttpServletRequest request) {
        RequestCacheThreadLocal.putHttpRequest(request, REQUEST_CACHE.get());
        if (RequestCacheThreadLocal.canRequestMutateState() != HttpUtils.canMethodMutateState((String)request.getMethod())) {
            String warning = "Unexpected attempt to change request mutativity from " + RequestCacheThreadLocal.canRequestMutateState() + " to " + HttpUtils.canMethodMutateState((String)request.getMethod());
            log.warn((Object)warning);
            if (SystemProperty.ATLASSIAN_DEV_MODE.getValue(false)) {
                throw new IllegalArgumentException(warning);
            }
        }
    }

    @NotNull
    public static HttpServletRequest getNonNullRequest() {
        HttpServletRequest request = RequestCacheThreadLocal.getRequest();
        Preconditions.checkState((request != null ? 1 : 0) != 0, (Object)"HTTP request not available");
        return request;
    }

    @NotNull
    public static HttpServletResponse getNonNullResponse() {
        HttpServletResponse response = RequestCacheThreadLocal.getResponse();
        Preconditions.checkState((response != null ? 1 : 0) != 0, (Object)"HTTP response not available");
        return response;
    }

    private static void putHttpRequest(@NotNull HttpServletRequest request, @NotNull Map<String, Object> map) {
        RequestCacheThreadLocal.assertNoXss(request.getContextPath() + "/" + request.getServletPath() + "?" + request.getQueryString());
        map.put(HTTP_REQUEST_KEY, request);
        map.put(HTTP_REQUEST_IS_MUTATIVE_KEY, HttpUtils.canMethodMutateState((String)request.getMethod()));
    }

    private static void assertNoXss(String string) {
        if (UrlUtils.hasXssRelatedCharacters((String)string)) {
            throw new IllegalArgumentException("Dangerous string detected: " + string);
        }
    }
}

