/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.utils.BambooFileAttributes;
import com.atlassian.bamboo.utils.BambooFiles;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecureTemporaryFiles {
    private SecureTemporaryFiles() {
    }

    public static File create(@NotNull TemporaryFileSpec temporaryFileSpec) throws IOException {
        return SecureTemporaryFiles.createPath(temporaryFileSpec).toFile();
    }

    public static Path createPath(@NotNull TemporaryFileSpec temporaryFileSpec) throws IOException {
        Path secureTempFile = SecureTemporaryFiles.createSecureTempFile(temporaryFileSpec);
        if (temporaryFileSpec.is83PathPreferred()) {
            return BambooFilenameUtils.shortenNameIfPossible((Path)secureTempFile);
        }
        return secureTempFile;
    }

    public static FileSpecBuilder builder() {
        return new FileSpecBuilder();
    }

    private static Path createSecureTempFile(TemporaryFileSpec temporaryFileSpec) throws IOException {
        Path tempFile;
        String name = temporaryFileSpec.getName();
        File dir = temporaryFileSpec.getTemporaryDir();
        if (dir == null) {
            dir = SystemUtils.getJavaIoTmpDir();
        }
        if (Files.exists(tempFile = Paths.get(dir.getAbsolutePath(), name), new LinkOption[0])) {
            BambooFiles.delete((Path)tempFile);
        }
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                Files.createFile(tempFile, new FileAttribute[0]);
            } else {
                Files.createFile(tempFile, SecureTemporaryFiles.getOwnerOnlyAttributes(temporaryFileSpec.isExecutable()));
            }
        }
        catch (IOException e) {
            throw new IOException("Could not create file: " + tempFile, e);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            boolean isPermissionSet;
            BambooFiles.setAccessibleOnlyByOwner((Path)tempFile);
            if (temporaryFileSpec.isExecutable() && !(isPermissionSet = BambooFileUtils.setExecutableByOwnerOnly(tempFile.toFile())) && temporaryFileSpec.shouldFailWhenPermissionsNotSet()) {
                throw new IOException("Unable to set file permissions to executable by owner only");
            }
        }
        tempFile.toFile().deleteOnExit();
        return tempFile;
    }

    private static FileAttribute<?> getOwnerOnlyAttributes(boolean isExecutable) {
        EnumSet<PosixFilePermission> permissions;
        if (isExecutable) {
            permissions = BambooFileAttributes.OWNER_PERMISSIONS;
        } else {
            permissions = EnumSet.copyOf(BambooFileAttributes.OWNER_PERMISSIONS);
            permissions.remove((Object)PosixFilePermission.OWNER_EXECUTE);
        }
        return PosixFilePermissions.asFileAttribute(permissions);
    }

    public static class FileSpecBuilder {
        protected String prefix;
        protected String suffix;
        protected String name;
        protected boolean executable;
        protected File directory;
        protected boolean is83PathPreferred;
        protected boolean useShortDirectoryName;
        protected boolean failWhenPermissionsNotSet;

        protected FileSpecBuilder() {
        }

        public FileSpecBuilder setPrefix(@NotNull String prefix) {
            Preconditions.checkState((this.name == null ? 1 : 0) != 0, (Object)"Cannot set both prefix and name");
            this.prefix = prefix;
            return this;
        }

        public FileSpecBuilder setSuffix(@Nullable String suffix) {
            Preconditions.checkState((this.name == null ? 1 : 0) != 0, (Object)"Cannot set both suffix and name");
            this.suffix = suffix;
            return this;
        }

        public FileSpecBuilder setName(@NotNull String name) {
            Preconditions.checkState((this.prefix == null && this.suffix == null ? 1 : 0) != 0, (Object)"You cannot set name when prefix or suffix is set");
            this.name = name;
            return this;
        }

        public FileSpecBuilder setExecutable(boolean executable) {
            this.executable = executable;
            return this;
        }

        public FileSpecBuilder setDir(@Nullable File directory) {
            this.directory = directory;
            return this;
        }

        public FileSpecBuilder setPrefer83PathsOnWindows(boolean is83PathPreferred) {
            this.is83PathPreferred = is83PathPreferred;
            return this;
        }

        public FileSpecBuilder useShortDirectoryName() {
            this.useShortDirectoryName = true;
            return this;
        }

        public FileSpecBuilder failWhenPermissionsNotSet() {
            this.failWhenPermissionsNotSet = true;
            return this;
        }

        public TemporaryFileSpec build() {
            Preconditions.checkArgument((this.name != null || this.prefix != null ? 1 : 0) != 0, (Object)"Either name or prefix has to be set");
            return new TemporaryFileSpec(this);
        }
    }

    public static class TemporaryFileSpec {
        protected String name;
        private final boolean executable;
        private final boolean failWhenPermissionsNotSet;
        private final File temporaryDir;
        private final boolean is83PathPreferred;

        protected TemporaryFileSpec(@NotNull FileSpecBuilder spec) {
            this.name = spec.name != null ? spec.name : BambooFilenameUtils.makeTempFileName((String)spec.prefix, (String)spec.suffix);
            this.executable = spec.executable;
            this.failWhenPermissionsNotSet = spec.failWhenPermissionsNotSet;
            this.temporaryDir = spec.useShortDirectoryName ? this.shortenIfNeeded(spec.directory, spec.is83PathPreferred) : spec.directory;
            this.is83PathPreferred = spec.is83PathPreferred;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemporaryFileSpec that = (TemporaryFileSpec)o;
            if (this.executable != that.executable) {
                return false;
            }
            if (this.failWhenPermissionsNotSet != that.failWhenPermissionsNotSet) {
                return false;
            }
            if (this.is83PathPreferred != that.is83PathPreferred) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.temporaryDir != null ? !this.temporaryDir.equals(that.temporaryDir) : that.temporaryDir != null);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.executable ? 1 : 0);
            result = 31 * result + (this.failWhenPermissionsNotSet ? 1 : 0);
            result = 31 * result + (this.temporaryDir != null ? this.temporaryDir.hashCode() : 0);
            result = 31 * result + (this.is83PathPreferred ? 1 : 0);
            return result;
        }

        @Nullable
        private File shortenIfNeeded(@Nullable File temporaryDir, boolean is83PathPreferred) {
            if (is83PathPreferred) {
                return temporaryDir;
            }
            if (temporaryDir == null || temporaryDir.equals(SystemUtils.getJavaIoTmpDir())) {
                return BambooFileUtils.JAVA_IO_SHORT_TMPDIR.get();
            }
            return BambooFilenameUtils.shortenNameIfPossible((File)temporaryDir);
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean isExecutable() {
            return this.executable;
        }

        @Nullable
        public File getTemporaryDir() {
            return this.temporaryDir;
        }

        public boolean is83PathPreferred() {
            return this.is83PathPreferred;
        }

        public boolean shouldFailWhenPermissionsNotSet() {
            return this.failWhenPermissionsNotSet;
        }
    }
}

