/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.atlassian.bamboo.utils.BambooFiles;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedTemporaryFiles {
    private static final Logger log = Logger.getLogger(SharedTemporaryFiles.class);
    private static final CacheLoader<? super SharedTemporaryFileSpec, File> loader = new CacheLoader<SharedTemporaryFileSpec, File>(){

        public File load(SharedTemporaryFileSpec data) throws IOException {
            return SharedTemporaryFiles.createTempFile(data);
        }
    };
    private static final RemovalListener<? super SecureTemporaryFiles.TemporaryFileSpec, ? super File> removalListener = removalNotification -> {
        File file = (File)removalNotification.getValue();
        if (file != null) {
            BambooFiles.deleteLogIfError((Path)file.toPath(), (Logger)log);
        }
    };
    private static final LoadingCache<SharedTemporaryFileSpec, File> TEMPORARY_FILES = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(removalListener).build(loader);

    public static FileSpecBuilder builder(@NotNull String content) {
        return new FileSpecBuilder(content);
    }

    private SharedTemporaryFiles() {
    }

    private static File createTempFile(SharedTemporaryFileSpec temporaryFileSpec) throws IOException {
        File file = SecureTemporaryFiles.create(temporaryFileSpec);
        FileUtils.writeStringToFile((File)file, (String)temporaryFileSpec.releaseContent(), (Charset)StandardCharsets.UTF_8);
        if (temporaryFileSpec.isExecutable()) {
            BambooFileUtils.setExecutableByOwnerOnly(file);
        }
        if (!temporaryFileSpec.is83PathPreferred()) {
            return file;
        }
        return BambooFilenameUtils.shortenNameIfPossible((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File create(@NotNull SharedTemporaryFileSpec temporaryFileSpec) throws IOException {
        try {
            File file;
            File file2 = file = (File)TEMPORARY_FILES.get((Object)temporaryFileSpec);
            synchronized (file2) {
                if (!file.exists()) {
                    SharedTemporaryFiles.createTempFile(temporaryFileSpec);
                }
            }
            return file;
        }
        catch (ExecutionException e) {
            throw BambooObjectUtils.rethrowAnyCauseThatIsInstanceOf((Throwable)e, IOException.class);
        }
    }

    public static final class FileSpecBuilder
    extends SecureTemporaryFiles.FileSpecBuilder {
        private final String content;

        private FileSpecBuilder(@NotNull String content) {
            this.content = content;
        }

        @Override
        public FileSpecBuilder setName(@NotNull String name) {
            this.name = name;
            return this;
        }

        @Override
        public FileSpecBuilder setPrefix(@NotNull String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public FileSpecBuilder setSuffix(@Nullable String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        public FileSpecBuilder setExecutable(boolean executable) {
            this.executable = executable;
            return this;
        }

        @Override
        public FileSpecBuilder setDir(@Nullable File directory) {
            this.directory = directory;
            return this;
        }

        @Override
        public FileSpecBuilder setPrefer83PathsOnWindows(boolean is83PathPreferred) {
            this.is83PathPreferred = is83PathPreferred;
            return this;
        }

        @Override
        public SharedTemporaryFileSpec build() {
            Preconditions.checkArgument((this.name != null || this.prefix != null ? 1 : 0) != 0, (Object)"Either name or prefix has to be set");
            return new SharedTemporaryFileSpec(this);
        }
    }

    public static final class SharedTemporaryFileSpec
    extends SecureTemporaryFiles.TemporaryFileSpec {
        private String content;
        private final int contentHash;

        public SharedTemporaryFileSpec(@NotNull FileSpecBuilder spec) {
            super(spec);
            this.content = spec.content;
            this.contentHash = this.content.hashCode();
            if (spec.name == null) {
                String suffix = Integer.toHexString(this.contentHash);
                if (spec.suffix != null) {
                    suffix = suffix + spec.suffix;
                }
                this.name = spec.prefix + suffix;
            }
        }

        public String releaseContent() {
            String content = this.content;
            this.content = null;
            return content;
        }

        public int getContentHash() {
            return this.contentHash;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SharedTemporaryFileSpec that = (SharedTemporaryFileSpec)o;
            return this.contentHash == that.contentHash && super.equals(that);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.contentHash;
        }
    }
}

