/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.utils.i18n.BambooTextProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.opensymphony.xwork2.TextProvider;
import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.commons.text.StringEscapeUtils;

public final class TextProviderUtils {
    private TextProviderUtils() {
    }

    public static String getText(TextProvider textProvider, String msg, String ... params) {
        return textProvider.getText(msg, params);
    }

    public static String getText(I18nResolver i18nResolver, String msg, String ... params) {
        return i18nResolver.getText(msg, (Serializable[])params);
    }

    public static Supplier<String> textSupplier(TextProvider textProvider, String key, String ... params) {
        return () -> textProvider.getText(key, params);
    }

    public static Supplier<String> textSupplier(I18nResolver i18nResolver, String key, String ... params) {
        return () -> i18nResolver.getText(key, (Serializable[])params);
    }

    public static String getHtml(TextProvider textProvider, String msg, String ... params) {
        String[] escapedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            escapedParams[i] = StringEscapeUtils.escapeHtml4((String)params[i]);
        }
        return textProvider.getText(msg, escapedParams);
    }

    public static String getHtml(I18nResolver i18nResolver, String msg, String ... params) {
        String[] escapedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            escapedParams[i] = StringEscapeUtils.escapeHtml4((String)params[i]);
        }
        return i18nResolver.getText(msg, (Serializable[])escapedParams);
    }

    public static TextProvider getTextProvider() {
        return BambooTextProvider.getInstance();
    }

    public static String getText(String i18nKey) {
        return TextProviderUtils.getTextProvider().getText(i18nKey);
    }
}

