/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.NumberUtils;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    private static final ImmutableMap<Pattern, Function<Matcher, Version>> STRICT_MATCHERS;
    private static final ImmutableMap<Pattern, Function<Matcher, Version>> LENIENT_MATCHERS;
    private final int major;
    private final int minor;
    private final int micro;
    private String productName;
    private String versionString;

    public Version(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major) {
        this(major, 0);
    }

    @Override
    public int compareTo(@NotNull Version o) {
        if (this.major != o.major) {
            return Integer.compare(this.major, o.major);
        }
        if (this.minor != o.minor) {
            return Integer.compare(this.minor, o.minor);
        }
        if (this.micro != o.micro) {
            return Integer.compare(this.micro, o.micro);
        }
        return 0;
    }

    public boolean isGreaterThan(@NotNull Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterOrEqualTo(@NotNull Version version) {
        return !this.isLessThan(version);
    }

    public boolean isLessThan(@NotNull Version version) {
        return this.compareTo(version) < 0;
    }

    public static Version of(@NotNull String version) throws IllegalArgumentException {
        return Version.of(version, false);
    }

    public static Version lenient(@NotNull String version) throws IllegalArgumentException {
        return Version.of(version, true);
    }

    private static Version of(@NotNull String version, boolean lenient) throws IllegalArgumentException {
        ImmutableMap<Pattern, Function<Matcher, Version>> matchers = lenient ? LENIENT_MATCHERS : STRICT_MATCHERS;
        return matchers.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(((Pattern)e.getKey()).matcher(version), e.getValue())).filter(e -> ((Matcher)e.getKey()).matches()).findFirst().map(e -> (Version)((Function)e.getValue()).apply(e.getKey())).orElseThrow(() -> new IllegalArgumentException("Malformed version - " + version));
    }

    private static int getInt(Matcher matcher, int pos) {
        return NumberUtils.stringToInt((String)matcher.group(pos));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.productName != null) {
            sb.append("[" + this.productName + "] ");
        }
        sb.append(this.major + "." + this.minor + "." + this.micro);
        if (this.versionString != null) {
            sb.append(" (" + this.versionString + ")");
        }
        return sb.toString();
    }

    public void setVersionString(String versionString) {
        this.versionString = versionString;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    static {
        String PATTERN_3_DIGITS = "(\\d+)\\.(\\d+)\\.(\\d+)";
        String PATTERN_2_DIGITS = "(\\d+)\\.(\\d+)";
        String PATTERN_1_DIGIT = "(\\d+)";
        String LENIENT_SUFFIX = ".*";
        Function<Matcher, Version> PARSER_3_DIGITS = m -> new Version(Version.getInt(m, 1), Version.getInt(m, 2), Version.getInt(m, 3));
        Function<Matcher, Version> PARSER_2_DIGITS = m -> new Version(Version.getInt(m, 1), Version.getInt(m, 2));
        Function<Matcher, Version> PARSER_1_DIGIT = m -> new Version(Version.getInt(m, 1));
        STRICT_MATCHERS = ImmutableMap.of((Object)Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)"), PARSER_3_DIGITS, (Object)Pattern.compile("(\\d+)\\.(\\d+)"), PARSER_2_DIGITS, (Object)Pattern.compile("(\\d+)"), PARSER_1_DIGIT);
        LENIENT_MATCHERS = ImmutableMap.of((Object)Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*"), PARSER_3_DIGITS, (Object)Pattern.compile("(\\d+)\\.(\\d+).*"), PARSER_2_DIGITS, (Object)Pattern.compile("(\\d+).*"), PARSER_1_DIGIT);
    }
}

