/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util.comparator;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;

public class SinglePropertyComparator<T, P>
implements Comparator<T> {
    private static final Logger log = Logger.getLogger(SinglePropertyComparator.class);
    private final Method readMethod;
    private final Comparator<P> propertyComparator;

    public SinglePropertyComparator(@NotNull Class<T> beanClass, @NotNull String propertyName, @NotNull Class<P> propertyReturnType, @Nullable Comparator<P> propertyComparator) {
        this.readMethod = BeanUtils.findMethod((Class)((Class)Preconditions.checkNotNull(beanClass)), (String)("get" + StringUtils.capitalize((String)((String)Preconditions.checkNotNull((Object)propertyName)))), (Class[])new Class[0]);
        this.propertyComparator = propertyComparator;
        if (this.readMethod == null) {
            throw new IllegalArgumentException(String.format("Can't find method to access property [%s] on class [%s]", propertyName, beanClass.getName()));
        }
        if (!this.readMethod.getReturnType().equals(propertyReturnType)) {
            throw new IllegalArgumentException(String.format("Property's [%s] return type is not [%s]", propertyName, propertyReturnType.getName()));
        }
    }

    @Override
    public int compare(T o1, T o2) {
        Object p1 = null;
        Object p2 = null;
        try {
            p1 = this.readMethod.invoke(o1, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)String.format("Could not invoke method %s", this.readMethod.getName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)String.format("Could not invoke method %s", this.readMethod.getName()), (Throwable)e);
        }
        try {
            p2 = this.readMethod.invoke(o2, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)String.format("Could not invoke method %s", this.readMethod.getName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)String.format("Could not invoke method %s", this.readMethod.getName()), (Throwable)e);
        }
        if (o1 == null || o2 == null) {
            return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
        }
        if (this.propertyComparator == null) {
            return new CompareToBuilder().append(p1, p2).toComparison();
        }
        return new CompareToBuilder().append(p1, p2, this.propertyComparator).toComparison();
    }
}

