/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.Queue;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public class BlockingCircularFifoQueue<E> {
    private final Queue<E> delegate;

    public BlockingCircularFifoQueue(int size) {
        this.delegate = new CircularFifoQueue(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        Queue<E> queue = this.delegate;
        synchronized (queue) {
            E item;
            while ((item = this.delegate.poll()) == null) {
                this.waitForItem();
            }
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(E message) {
        Queue<E> queue = this.delegate;
        synchronized (queue) {
            this.delegate.add(message);
            this.delegate.notifyAll();
        }
    }

    @VisibleForTesting
    void waitForItem() throws InterruptedException {
        this.delegate.wait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int size() {
        Queue<E> queue = this.delegate;
        synchronized (queue) {
            return this.delegate.size();
        }
    }
}

