/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.struts.ValidationAware;
import com.opensymphony.xwork2.TextProvider;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooFieldValidate {
    private static final Logger log = Logger.getLogger(BambooFieldValidate.class);

    private BambooFieldValidate() {
    }

    public static void checkFieldXssSafety(ValidationAware validationAware, TextProvider textProvider, String fieldName, String fieldValue) {
        if (BambooStringUtils.containsXssRelatedCharacters((String)fieldValue)) {
            validationAware.addFieldError(fieldName, textProvider.getText("error.string.unsafe", null, BambooStringUtils.getFirstXssRelatedCharacter((String)fieldValue)));
        }
    }

    public static ErrorCollection checkFieldXssSafety(TextProvider textProvider, String fieldName, String fieldValue) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        if (BambooStringUtils.containsXssRelatedCharacters((String)fieldValue)) {
            simpleErrorCollection.addError(fieldName, textProvider.getText("error.string.unsafe", null, BambooStringUtils.getFirstXssRelatedCharacter((String)fieldValue)));
        }
        return simpleErrorCollection;
    }

    public static void checkFieldXssSafety(@NotNull Map<String, String> fieldErrors, TextProvider textProvider, String fieldName, String fieldValue) {
        if (BambooStringUtils.containsXssRelatedCharacters((String)fieldValue)) {
            fieldErrors.put(fieldName, textProvider.getText("error.string.unsafe", null, BambooStringUtils.getFirstXssRelatedCharacter((String)fieldValue)));
        }
    }

    public static void checkFieldXssSafety(@NotNull ErrorCollection errorCollection, TextProvider textProvider, String fieldName, String fieldValue) {
        if (BambooStringUtils.containsXssRelatedCharacters((String)fieldValue)) {
            errorCollection.addError(fieldName, textProvider.getText("error.string.unsafe", null, BambooStringUtils.getFirstXssRelatedCharacter((String)fieldValue)));
        }
    }

    public static void checkFieldXssSafety(@NotNull ErrorCollection errorCollection, I18nResolver i18nResolver, String fieldName, String fieldValue) {
        if (BambooStringUtils.containsXssRelatedCharacters((String)fieldValue)) {
            errorCollection.addError(fieldName, i18nResolver.getText("error.string.unsafe", new Serializable[]{BambooStringUtils.getFirstXssRelatedCharacter((String)fieldValue)}));
        }
    }

    public static boolean findFieldRelaxedXssViolation(ErrorCollection errorCollection, TextProvider textProvider, String fieldName, String fieldValue) {
        if (BambooStringUtils.containsRelaxedXssRelatedCharacters((String)fieldValue)) {
            errorCollection.addError(fieldName, textProvider.getText("error.string.unsafe", null, BambooStringUtils.getFirstRelaxedXssRelatedCharacter((String)fieldValue)));
            return true;
        }
        return false;
    }

    public static boolean findFieldRelaxedXssViolation(ErrorCollection errorCollection, I18nResolver i18nResolver, String fieldName, String fieldValue) {
        if (BambooStringUtils.containsRelaxedXssRelatedCharacters((String)fieldValue)) {
            errorCollection.addError(fieldName, i18nResolver.getText("error.string.unsafe", new Serializable[]{BambooStringUtils.getFirstRelaxedXssRelatedCharacter((String)fieldValue)}));
            return true;
        }
        return false;
    }

    public static boolean findFieldShellInjectionViolation(ErrorCollection errorCollection, I18nResolver i18nResolver, String fieldName, @Nullable String fieldValue) {
        if (BambooStringUtils.containsShellInjectionRelatedCharacters((String)fieldValue)) {
            errorCollection.addError(fieldName, i18nResolver.getText("error.string.unsafe", new Serializable[]{BambooStringUtils.getFirstShellInjectionRelatedCharacters((String)fieldValue)}));
            return true;
        }
        return false;
    }
}

