/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.core.ResultKeyProvider;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.fage.Result;
import com.atlassian.bamboo.utils.functions.Numeric;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import com.opensymphony.xwork2.TextProvider;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooFunctions {
    private static final Logger log = Logger.getLogger(BambooFunctions.class);

    private BambooFunctions() {
    }

    public static <F, T> Function<F, T> constant(@Nullable T result) {
        return Functions.constant(result);
    }

    public static <T> Function<Integer, T> itemFromList(List<T> items) {
        return items::get;
    }

    public static Function<BambooIdProvider, Long> getBambooObjectId() {
        return BambooIdProvider::getId;
    }

    public static BiFunction<Long, Long, Long> addLong() {
        return Numeric.addLong();
    }

    public static Function<List<Long>, Long> foldListOfLong() {
        return Numeric.foldListOfLong();
    }

    public static BiFunction<Long, Long, Long> max() {
        return Numeric.max();
    }

    public static <E extends Exception, T> Function<Result<E, T>, T> getResultOrNull() {
        return result -> result.getResult(null);
    }

    public static <E extends Exception, T> Predicate<Result<E, T>> resultIsException() {
        return Result::hasException;
    }

    public static <E extends Exception, T> Predicate<Result<E, T>> resultIsResult() {
        return result -> !result.hasException();
    }

    public static Function<Enum, String> getEnumName() {
        return Enum::name;
    }

    public static <E extends Enum<E>> BiFunction<E, E, E> lesserOf() {
        return (arg1, arg2) -> {
            EnumSet<Enum> args = EnumSet.of(arg1, arg2);
            List leastOne = Ordering.natural().leastOf(args, 1);
            return (Enum)leastOne.get(0);
        };
    }

    public static Function<String, String> translate(@NotNull TextProvider textProvider) {
        return arg_0 -> ((TextProvider)textProvider).getText(arg_0);
    }

    public static Function<ResultKeyProvider, ResultKey> getResultKey() {
        return ResultKeyProvider::getResultKey;
    }

    public static Function<ArtifactLink, Artifact> getArtifactFromArtifactLink() {
        return ArtifactLink::getArtifact;
    }

    public static Function<Artifact, String> getArtifactName() {
        return Artifact::getLabel;
    }

    public static <A, B> Function<Pair<A, B>, A> firstOfPair() {
        return Pair::getFirst;
    }

    public static <K, V, R> java.util.function.Function<? super Map.Entry<K, V>, R> liftToEntryFunction(BiFunction<K, V, R> biFunction) {
        return entry -> biFunction.apply(entry.getKey(), entry.getValue());
    }
}

