/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooMergedResourceBundle
extends ResourceBundle {
    private static final Logger log = Logger.getLogger(BambooMergedResourceBundle.class);
    private List<ResourceBundle> bundles;

    public BambooMergedResourceBundle(String ... baseNameList) {
        this.bundles = new ArrayList<ResourceBundle>(baseNameList.length);
        for (String baseName : baseNameList) {
            try {
                this.bundles.add(ResourceBundle.getBundle(baseName));
            }
            catch (MissingResourceException e) {
                log.warn((Object)("Cannot locate bundle for " + baseName), (Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public Enumeration<String> getKeys() {
        return new Enumeration<String>(){
            private Set<String> keys = new HashSet<String>();
            private Iterator<String> i;
            {
                for (ResourceBundle b : BambooMergedResourceBundle.this.bundles) {
                    this.keys.addAll(EnumerationUtils.toList(b.getKeys()));
                }
                this.i = this.keys.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public String nextElement() {
                return this.i.next();
            }
        };
    }

    @Override
    protected Object handleGetObject(@NotNull String key) {
        Preconditions.checkNotNull((Object)key);
        Object value = null;
        for (ResourceBundle b : this.bundles) {
            try {
                value = b.getObject(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (value == null) {
            log.warn((Object)("Cannot find key " + key));
        }
        return value;
    }
}

