/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.PlanDependency;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.strategy.BuildStrategy;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableDeletable;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectPredicates;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskPredicates;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.TitleProvider;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityPredicates;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooPredicates {
    private BambooPredicates() {
    }

    public static boolean isNotDeleted(ImmutableDeletable deletable) {
        return !deletable.isMarkedForDeletion();
    }

    @NotNull
    public static <T> com.google.common.base.Predicate<? super Class<? extends T>> isAssignableFrom(Class clazz) {
        return input -> input != null && input.isAssignableFrom(clazz);
    }

    @NotNull
    public static com.google.common.base.Predicate<Project> projectIsNotEmpty(@NotNull CachedPlanManager cachedPlanManager) {
        return proj -> ProjectPredicates.withPlansThat(cachedPlanManager, p -> true).test((Project)proj);
    }

    @NotNull
    public static com.google.common.base.Predicate<PlanDependency> dependencyChildIsChain() {
        return DependencyChildPredicate.IS_CHAIN;
    }

    @NotNull
    public static com.google.common.base.Predicate<PlanDependency> dependencyParentIsChain() {
        return DependencyParentPredicate.IS_CHAIN;
    }

    @NotNull
    public static com.google.common.base.Predicate<PlanDependency> dependencyNotEditable() {
        return DependencyNotEditablePredicate.INSTANCE;
    }

    public static boolean hasTestCases(@NotNull TestClassResult testClassResult) {
        return !testClassResult.getTestCaseResultsSet().isEmpty();
    }

    @NotNull
    public static com.google.common.base.Predicate<Labelling> labelNameIn(final @NotNull Iterable<String> labelNames) {
        return new com.google.common.base.Predicate<Labelling>(){

            public boolean apply(@Nullable Labelling labelling) {
                return labelling != null && Iterables.contains((Iterable)labelNames, (Object)labelling.getLabel().getName());
            }
        };
    }

    @NotNull
    public static com.google.common.base.Predicate<ElasticInstanceSchedule> elasticInstanceScheduleIsEnabled() {
        return ElasticInstanceScheduleIsEnabledPredicate.INSTANCE;
    }

    @NotNull
    public static com.google.common.base.Predicate<SystemProperty> systemPropertyHasValue() {
        return SystemPropertyHasValuePredicate.INSTANCE;
    }

    public static com.google.common.base.Predicate<TaskDefinition> isFinalizingTaskDefinition() {
        return TaskPredicates.isFinalisingTaskDefinition();
    }

    public static com.google.common.base.Predicate<TaskDefinition> hasTaskDefinitionEqualId(long id) {
        return TaskPredicates.hasTaskDefinitionEqualId(id);
    }

    public static com.google.common.base.Predicate<TaskResult> isTaskResultPluginKeyEqual(@NotNull String pluginKey) {
        return TaskPredicates.isTaskResultPluginKeyEqual(pluginKey);
    }

    public static com.google.common.base.Predicate<Capability> capabilityKeyStartsWith(@NotNull String prefix) {
        return CapabilityPredicates.capabilityKeyStartsWith(prefix);
    }

    public static com.google.common.base.Predicate<Method> methodHasNoArguments() {
        return BambooReflectionPredicates.MethodHasNoArgumentsPredicate.INSTANCE;
    }

    public static com.google.common.base.Predicate<Method> methodNameMatchesPattern(Pattern pattern) {
        return new BambooReflectionPredicates.MethodNameMatchesPatternPredicate(pattern);
    }

    public static Predicate<PlanRepositoryDefinition> isChainTrigger(@NotNull ImmutableChain chain, @Nullable Set<Long> triggeringRepositories) {
        return new ChainTriggerPredicate(chain, triggeringRepositories);
    }

    public static com.google.common.base.Predicate<BambooIdProvider> hasBambooObjectEqualId(@NotNull BambooIdProvider bambooObject) {
        return new HasBambooObjectEqualIdPredicate(bambooObject.getId());
    }

    public static com.google.common.base.Predicate<BambooIdProvider> hasBambooObjectEqualId(long id) {
        return new HasBambooObjectEqualIdPredicate(id);
    }

    public static com.google.common.base.Predicate<ArtifactLink> artifactLinkHasArtifactWithName(@NotNull String artifactName) {
        return Predicates.compose(BambooPredicates.artifactHasName(artifactName), BambooFunctions.getArtifactFromArtifactLink());
    }

    public static com.google.common.base.Predicate<Artifact> artifactHasName(@NotNull String artifactName) {
        return artifact -> artifactName.equals(artifact.getLabel());
    }

    public static com.google.common.base.Predicate<TitleProvider> hasEqualTitle(String title) {
        return new HasEqualTitlePredicate(title);
    }

    public static <T> com.google.common.base.Predicate<Iterable<? extends T>> any(final @NotNull com.google.common.base.Predicate<T> predicate) {
        return new com.google.common.base.Predicate<Iterable<? extends T>>(){

            public boolean apply(@Nullable Iterable<? extends T> input) {
                return Iterables.any((Iterable)((Iterable)Preconditions.checkNotNull(input)), (com.google.common.base.Predicate)predicate);
            }
        };
    }

    public static com.google.common.base.Predicate<BuildStrategy> hasBuildStrategyEqualKey(@NotNull String buildStrategyKey) {
        return input -> buildStrategyKey.equals(input.getKey());
    }

    public static Predicate<NotificationRule> hasNotificationRuleRecipientType(@NotNull String recipientType) {
        return notificationRule -> recipientType.equals(notificationRule.getRecipientType());
    }

    public static Predicate<NotificationRule> hasNotificationRuleRecipient(@NotNull String recipient) {
        return notificationRule -> recipient.equals(notificationRule.getRecipient());
    }

    public static com.google.common.base.Predicate<ImmutableArtifactDefinitionBase> isArtifactShared() {
        return ImmutableArtifactDefinitionBase::isSharedArtifact;
    }

    public static <T, K> Predicate<T> distinct(Function<? super T, K> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static <K, V> Predicate<? super Map.Entry<K, V>> liftToEntryPredicate(BiPredicate<K, V> biPredicate) {
        return entry -> biPredicate.test(entry.getKey(), entry.getValue());
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return a -> predicate.test(function.apply(a));
    }

    public static <T> Predicate<T> onceTrueAlwaysTrue(final Predicate<T> predicate) {
        return new Predicate<T>(){
            private boolean onceTrueAlwaysTrue;

            @Override
            public boolean test(T t) {
                this.onceTrueAlwaysTrue |= predicate.test(t);
                return this.onceTrueAlwaysTrue;
            }
        };
    }

    public static <T> Predicate<T> testFirstApplyToAll(final Predicate<T> predicate) {
        return new Predicate<T>(){
            private final AtomicReference<Boolean> result = new AtomicReference();

            @Override
            public synchronized boolean test(T t) {
                if (this.result.get() == null) {
                    this.result.set(predicate.test(t));
                }
                return this.result.get();
            }
        };
    }

    private static class HasEqualTitlePredicate
    implements com.google.common.base.Predicate<TitleProvider> {
        private final String title;

        private HasEqualTitlePredicate(String title) {
            this.title = title;
        }

        public boolean apply(@Nullable TitleProvider input) {
            return new CompareToBuilder().append((Object)this.title, (Object)((TitleProvider)Preconditions.checkNotNull((Object)input)).getTitle()).toComparison() == 0;
        }
    }

    private static enum SystemPropertyHasValuePredicate implements com.google.common.base.Predicate<SystemProperty>
    {
        INSTANCE;


        public boolean apply(@Nullable SystemProperty property) {
            return ((SystemProperty)Preconditions.checkNotNull((Object)property)).getValue() != null;
        }
    }

    private static enum ElasticInstanceScheduleIsEnabledPredicate implements com.google.common.base.Predicate<ElasticInstanceSchedule>
    {
        INSTANCE;


        public boolean apply(@Nullable ElasticInstanceSchedule schedule) {
            return ((ElasticInstanceSchedule)Preconditions.checkNotNull((Object)schedule)).isEnabled();
        }
    }

    private static class BambooReflectionPredicates {
        private BambooReflectionPredicates() {
        }

        private static class MethodNameMatchesPatternPredicate
        implements com.google.common.base.Predicate<Method> {
            private final Pattern pattern;

            private MethodNameMatchesPatternPredicate(@NotNull Pattern pattern) {
                this.pattern = pattern;
            }

            public boolean apply(@Nullable Method method) {
                return this.pattern.matcher(((Method)Preconditions.checkNotNull((Object)method)).getName()).matches();
            }
        }

        private static enum MethodHasNoArgumentsPredicate implements com.google.common.base.Predicate<Method>
        {
            INSTANCE;


            public boolean apply(@Nullable Method method) {
                return ((Method)Preconditions.checkNotNull((Object)method)).getParameterTypes().length == 0;
            }
        }
    }

    private static enum InterestingTestResultsPredicate implements com.google.common.base.Predicate<TestClassResult>
    {
        INSTANCE;


        public boolean apply(@Nullable TestClassResult testClassResult) {
            return testClassResult != null && BambooPredicates.hasTestCases(testClassResult);
        }
    }

    private static enum DependencyNotEditablePredicate implements com.google.common.base.Predicate<PlanDependency>
    {
        INSTANCE;


        public boolean apply(@Nullable PlanDependency dependency) {
            return dependency != null && !dependency.isEditable();
        }
    }

    private static enum DependencyParentPredicate implements com.google.common.base.Predicate<PlanDependency>
    {
        IS_CHAIN(Chain.class);

        private final Class<? extends Plan> clazz;

        private DependencyParentPredicate(Class<? extends Plan> clazz) {
            this.clazz = clazz;
        }

        public boolean apply(@Nullable PlanDependency dependency) {
            if (dependency != null) {
                Plan plan = dependency.getParentPlan();
                return plan != null && Narrow.to((Object)plan, this.clazz) != null;
            }
            return false;
        }
    }

    private static enum DependencyChildPredicate implements com.google.common.base.Predicate<PlanDependency>
    {
        IS_CHAIN(Chain.class);

        private final Class<? extends Plan> clazz;

        private DependencyChildPredicate(Class<? extends Plan> clazz) {
            this.clazz = clazz;
        }

        public boolean apply(@Nullable PlanDependency dependency) {
            if (dependency != null) {
                Plan plan = dependency.getChildPlan();
                return plan != null && Narrow.to((Object)plan, this.clazz) != null;
            }
            return false;
        }
    }

    private static class ChainTriggerPredicate
    implements Predicate<PlanRepositoryDefinition> {
        @Nullable
        Set<Long> triggeringRepositories;
        boolean isBranch;

        private ChainTriggerPredicate(@NotNull ImmutableChain chain, @Nullable Set<Long> triggeringRepositories) {
            this.isBranch = chain.hasMaster();
            this.triggeringRepositories = triggeringRepositories;
        }

        @Override
        public boolean test(PlanRepositoryDefinition input) {
            Preconditions.checkNotNull((Object)input);
            if (this.triggeringRepositories == null) {
                return false;
            }
            if (this.triggeringRepositories.contains(input.getId())) {
                return true;
            }
            if (this.isBranch) {
                return this.triggeringRepositories.contains(input.getParentId());
            }
            return false;
        }
    }

    private static class HasBambooObjectEqualIdPredicate
    implements com.google.common.base.Predicate<BambooIdProvider> {
        private final long id;

        private HasBambooObjectEqualIdPredicate(long id) {
            this.id = id;
        }

        public boolean apply(@Nullable BambooIdProvider input) {
            return this.id == ((BambooIdProvider)Preconditions.checkNotNull((Object)input)).getId();
        }
    }
}

