/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class BambooRandomStringUtils {
    private static final SecureRandomService random;
    private static final int ALPHABETIC_CNT = 26;
    private static final char[] CHAR_TABLE_ALPHA_LOWER_UPPER;
    private static final char[] CHAR_TABLE_NUMERIC;
    private static final char[] CHAR_TABLE_ALPHANUMERIC;
    private static final char[] CHAR_TABLE_ASCII;

    private BambooRandomStringUtils() {
    }

    @NotNull
    public static String randomAlphanumeric(int length) {
        return BambooRandomStringUtils.randomString(length, CHAR_TABLE_ALPHANUMERIC);
    }

    @NotNull
    public static String randomAlphabetic(int length) {
        return BambooRandomStringUtils.randomString(length, CHAR_TABLE_ALPHA_LOWER_UPPER);
    }

    @NotNull
    public static String randomAscii(int length) {
        return BambooRandomStringUtils.randomString(length, CHAR_TABLE_ASCII);
    }

    @NotNull
    public static String randomNumeric(int length) {
        return BambooRandomStringUtils.randomString(length, CHAR_TABLE_NUMERIC);
    }

    private static String randomString(int length, char[] fromChars) {
        byte[] randomBytes = new byte[length];
        random.nextBytes(randomBytes);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(fromChars[(char)randomBytes[i] % fromChars.length]);
        }
        return sb.toString();
    }

    static {
        int i;
        random = DefaultSecureRandomService.getInstance();
        CHAR_TABLE_ALPHA_LOWER_UPPER = new char[52];
        CHAR_TABLE_NUMERIC = new char[10];
        CHAR_TABLE_ASCII = new char[128];
        for (i = 0; i < 26; ++i) {
            BambooRandomStringUtils.CHAR_TABLE_ALPHA_LOWER_UPPER[i] = (char)(i + 97);
            BambooRandomStringUtils.CHAR_TABLE_ALPHA_LOWER_UPPER[i + 26] = (char)(i + 65);
        }
        for (i = 0; i < CHAR_TABLE_NUMERIC.length; ++i) {
            BambooRandomStringUtils.CHAR_TABLE_NUMERIC[i] = (char)(i + 48);
        }
        CHAR_TABLE_ALPHANUMERIC = ArrayUtils.addAll((char[])CHAR_TABLE_ALPHA_LOWER_UPPER, (char[])CHAR_TABLE_NUMERIC);
        for (i = 0; i < CHAR_TABLE_ASCII.length; ++i) {
            BambooRandomStringUtils.CHAR_TABLE_ASCII[i] = (char)i;
        }
    }
}

